'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目发布
 */

const fs = require('fs');

async function pack(project, getProcesses, getScripts) {
	let data = JSON.parse(project.data);

	let scriptIDs = [];
	for(let view of data.views){
		traverseNode(view, (node) => {
			if (node.scripts && node.scripts.length > 0) {
				for (let {script} of node.scripts) {
					if (!scriptIDs.includes(script)) {
						scriptIDs.push(script);
					}
				}
			}
		});
	}
	//console.log('scriptIDs:', scriptIDs);
	let scriptsContainer = data.scripts = {};
	const scripts = await getScripts(scriptIDs);
	for (let scriptData of scripts) {
		let {id, code} = JSON.parse(scriptData);
		scriptsContainer[id] = code;
	}
	//console.log('scripts:', scriptsContainer);

	let processIDs = [];
	for (let process of data.processes) {
		for (let key in process.sub) {
			let p = process.sub[key];
			if (!processIDs.includes(p.meta)) {
				processIDs.push(p.meta);
			}
		}
	}
	//console.log('processIDs:', processIDs);
	let builtinProcesses = data.builtinProcesses = [];
	let processes = await getProcesses(processIDs);
	for(let processData of processes){
		let process = JSON.parse(processData);
		builtinProcesses.push(process);
	}
	//console.log('processes:', data.processes);

	fs.writeFileSync('test.json', JSON.stringify(data));
}

function traverseNode(root, callback) {
	callback(root);
	if (root.children && root.children.length > 0) {
		for (let childNode of root.children) {
			traverseNode(childNode, callback);
		}
	}
}

exports.pack = pack;
//# sourceMappingURL=index.js.map
