import decamelize from 'decamelize';
import babel from '@babel/core';
import { divideCode } from 'zeroing-code-divider';

/**
 * Created by rockyl on 2019-11-30.
 */

const UglifyJS = require('uglify-js');

async function compile(source, debug = false) {
	const {code, map} = await babel.transformAsync(source, {
		presets: [
			['@babel/env', {}]
		],
		babelrc: false,
		sourceMaps: debug,
	});

	const result = {
		code,
	};
	if (map) {
		result.sourcemap = map.mappings;
	}
	return result;
}

function uglify(source){
	const uglifyResult = UglifyJS.minify(source, {
	});
	if (!uglifyResult.error) {
		return uglifyResult.code;
	}
}

/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

const replaceFields = ['pageTitle', 'containerId'];
const TAG = 'zeroing-pack';

async function pack(data, options) {
	let version = Date.now() + Math.floor(Math.random() * 1000);
	pageTemplate(data, data.options, version);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
	}
}

function fillTpl(data, params) {
	const {options} = data;
	fillTemplate(options.newTpl, options, params);

	const newTpl = options.newTpl;
	delete options.newTpl;
	return newTpl;
}

async function packData(data, {debug, packedAssets, getProcesses, getScripts, getCustoms}) {
	let newData = {};
	newData.options = data.options;
	newData.views = data.views;
	newData.assets = packedAssets || data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;

	delete newData.options.tpl;
	deleteUnusedData(newData.processes);

	console.log(TAG, 'start');

	const {
		processScriptContent,
		scriptsContent,
		customScriptContent,
	} = await divideCode(newData, {
		debug,
		uglify, compile,
		getProcesses, getScripts, getCustoms,
	});

	/*/!*=====START process =====*!/
	console.log(TAG, 'start process');
	let processIDs = [];
	findDepPidsBat(processIDs, newData.processes);
	let builtinProcesses = newData.builtinProcesses = [];

	let bProcessIDs = processIDs;
	while (true) {
		let newPids = await addBuiltinProcesses(builtinProcesses, bProcessIDs, getProcesses);
		bProcessIDs = [];
		for (let id of newPids) {
			if (!processIDs.includes(id)) {
				bProcessIDs.push(id);
				processIDs.push(id);
			}
		}
		if (bProcessIDs.length === 0) {
			break;
		}
	}

	for (let process of newData.processes) {
		processManager.deal(process);
	}

	console.log(TAG, 'processManager.generateCurrent()');

	processManager.generateCurrent();
	await processManager.compile(); //自定义过程先编译

	for (let process of builtinProcesses) {
		processManager.deal(process);
	}

	let processScriptContent = processManager.generate();
	//console.log(processScriptContent);
	if (!debug) {
		processScriptContent = uglify(processScriptContent);
	}
	/!*=====END process =====*!/

	/!*=====START script =====*!/
	console.log(TAG, 'start script');
	let scriptIDs = [];
	for (let view of newData.views) {
		traverseNode(view, (node) => {
			if (node.scripts && node.scripts.length > 0) {
				for (let {script} of node.scripts) {
					if (!scriptIDs.includes(script)) {
						scriptIDs.push(script);
					}
				}
			}
		});
	}
	//console.log('scriptIDs:', scriptIDs);
	//let scriptsContainer = newData.scripts = {};
	//let scriptsCode = '';
	if (scriptIDs.length > 0) {
		const scripts = await getScripts(scriptIDs);
		for (let scriptData of scripts) {
			let script = JSON.parse(scriptData);
			//scriptsContainer[id] = code;
			scriptManager.deal(script);
		}
		//console.log('scripts:', scriptsContainer);
	}

	let scriptsContent = scriptManager.generate();
	//console.log(scriptsContent);
	if (!debug) {
		scriptsContent = uglify(scriptsContent);
	}
	/!*=====END script =====*!/

	/!*=====START custom =====*!/
	console.log(TAG, 'start custom');
	//newData.customs = [];
	if (data.customs && data.customs.length > 0) {
		/!*newData.customs = *!/
		(await getCustoms(data.customs)).map(item => {
			customManager.deal(JSON.parse(item));
			//return JSON.parse(item);
		})
	}
	let customScriptContent = customManager.generate();
	//console.log(customScriptContent);
	if (!debug) {
		customScriptContent = uglify(customScriptContent);
	}
	/!*=====END custom =====*!/*/

	return {
		data: JSON.stringify(newData),
		processScriptContent,
		scriptsContent,
		customScriptContent,
	};
}

const unusedFields = ['design'];

function deleteUnusedData(processes) {
	for (let process of processes) {
		if (process.sub) {
			for (let uuid in process.sub) {
				let subProcess = process.sub[uuid];
				for (let field of unusedFields) {
					if (subProcess.hasOwnProperty(field)) {
						delete subProcess[field];
					}
				}
			}
		}
		if (process.metas && process.metas.length > 0) {
			deleteUnusedData(process.metas);
		}
	}
}

function pageTemplate(tpl, options, version) {
	const params = {
		version,
	};
	for (let field of replaceFields) {
		params[field] = options[field];
	}
	fillTemplate(options.tpl, options, params);
}

function fillTemplate(tpl, options, params) {
	for (let field in params) {
		const pattern = decamelize(field).toUpperCase();
		tpl = tpl.replace(new RegExp(`\\$${pattern}\\$`, 'g'), params[field]);
	}

	options.newTpl = tpl;
}

export { fillTpl, pack };
//# sourceMappingURL=index.es.js.map
