/**
 * Created by rockyl on 2019-11-13.
 */

const projectData = require('./project');
const {pack} = require('../dist/index');
const fs = require('fs');

let project = projectData();
(async function () {
	const result = await pack(project.data, {getProcesses, getScripts});

	const {version, data, tpl} = result;
	fs.writeFileSync('test.json', data);
	console.log('version:', version);
	console.log('template:\n', tpl);
})();

function getProcesses(ids) {
	return [
		JSON.stringify({
			id: 'entry',
			name: 'Entry',
			props: {},
			script: "resolve({type: 'success', payload: args});",
			output: ['success'],
		}),
	]
}

function getScripts(ids) {
	return [
		JSON.stringify({
			id: 'wave',
			name: 'Wave',
			props: {
				duration: {type: 'number', default: 1000},
				name: {type: 'string', default: 'hello'},
				color: {type: 'color', default: '#123456'},
				type: {type: ['rotate', 'jump', 'breath'], default: 'rotate'},
				ease: {type: ['linear', 'cubic', 'back'], default: 'linear'},
				autoPlay: {type: 'boolean', default: false},
			},
			code: `"use strict";
exports.__esModule = true;
var Wave = (function () {
    function Wave() {
    }
    Wave.prototype.mounted = function () {
        console.log('mounted', this.duration);
        this.host.anchorX = this.host.width / 2;
        this.host.anchorY = this.host.height / 2;
    };
    Wave.prototype.destroy = function () {
        console.log('destroy');
    };
    Wave.prototype.update = function (t) {
        this.host.rotation = t * 0.1;
    };
    Wave.prototype.awake = function () {
        console.log('awake');
    };
    Wave.prototype.sleep = function () {
        console.log('sleep');
    };
    return Wave;
}());
exports["default"] = Wave;`
		}),
	]
}