/**
 * Created by rockyl on 2019-09-23.
 */

const data = {
	options: {
		entrySceneView: 'view1',
		containerID: 'game-container',
		designWidth: 750,
		designHeight: 1334,
		frameRate: 60,
		scaleMode: 'fixedWidth',
		rendererType: 'webgl',
		tpl:`	<meta charset="UTF-8">
	<title>$PAGE_TITLE$</title>
	<meta name="viewport"
content="width=device-width,initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no"/>
	<meta name="apple-mobile-web-app-capable" content="yes"/>
	<meta name="full-screen" content="true"/>
	<meta name="screen-orientation" content="portrait"/>
	<meta name="x5-fullscreen" content="true"/>
	<meta name="360-fullscreen" content="true"/>
	<style>
		html,
		body {
		padding: 0;
		margin: 0;
		border: 0;
	
		width: 100%;
		height: 100%;
		overflow: hidden;
		position: absolute;
		background-color: white;
	}
	</style>
</head>

<body>
	<div id="$CONTAINER_ID$" style="line-height:0;font-size:0"></div>
	<script src="http://10.10.94.134:4002/dist/index.js"></script>
	<script>
		engine.launch('http://10.10.94.134:4002/examples/mock/test.json');
	</script>
`
	},
	"views": [{
		"name": "view1",
		"type": "node",
		"properties": {},
		"uuid": "3a357816-5581-41ba-aa6f-4a6cc40ae396",
		"children": [
			{
				"name": "rect",
				"type": "rect",
				"properties": {
					"width": 50,
					"height": 50,
					"fillColor": "rgba(105, 182, 255, 1)",
					"strokeWidth": 0,
					"x": 10,
					"y": 10
				},
				"uuid": "f97bbf76-6923-4669-b5a3-e6382753e49a",
				events: {
					click: {
						once: false,
						behaviors: [
							{
								uuid: 'aa1',
								alias: '主过程',
								meta: 'main',
							}
						]
					}
				},
				scripts: [
					{
						script: 'wave',
						props: {
							duration: 500,
							autoPlay: true,
							type: 'cubicIn',
						}
					}
				],
			},
		]
	}],
	"assets": [
		{
			"name": "face",
			"ext": ".png",
			"url": "//yun.duiba.com.cn/aurora/58323a0469a7467c99b34f8933ea65b507a0c655.png",
			"uuid": "3e496939-5fe6-42f2-b8fa-42c7a742e880"
		}, {
			"name": "还以是bug",
			"ext": ".jpg",
			"url": "//yun.duiba.com.cn/aurora/094832ace87c94bdb9e4a7821b3a3ebca0df2cd7.jpg",
			"uuid": "ec67a8a0-8708-43a4-888e-efb0fe7c2bd6"
		}, {
			"name": "嘿嘿",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/1ad10a4cf3488ef1400af1d6f353d9c577fe1049.gif",
			"uuid": "429803eb-0f68-4071-b68c-468980883ac4"
		}, {
			"name": "1643017",
			"ext": ".jpg",
			"url": "//yun.duiba.com.cn/aurora/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg",
			"uuid": "cc1ad757-ff4c-4cb9-b629-be355119d018"
		}, {
			"name": "0",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/616a413facbd406b81daac809a52bd0b648a7f4c.gif",
			"uuid": "0a5f2064-f5b4-41a9-8a54-2085e208d20f"
		}, {
			"name": "3",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/e052cb4a88d63330c37ecaf55ae8e7eb2246c433.gif",
			"uuid": "e4dacdd2-064f-413e-a8f0-6425ce6dcf12"
		}, {
			"name": "5",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/881193ea1bd975c8a59f38f2d1f0d0094db6ec7a.gif",
			"uuid": "bf822d51-a1b1-4ab6-8f49-a821863731d0"
		}, {
			"name": "4",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/2df4a5c5238f86704388517d2ba0faa6782fea1e.gif",
			"uuid": "9c1d46b4-d2f1-4733-8b93-39b2bb4db9d1"
		}, {
			"name": "1",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/0bc24c7bb68e3691bad89c8ae096b253af874a73.gif",
			"uuid": "db076340-e1db-4e2d-8bb2-7cc32ccdee43"
		}, {
			"name": "7",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/3e218541244d1ed1192274ad49ea70588b6cd0dc.gif",
			"uuid": "02aa47c3-dbdf-43d2-8cdc-869cab544bcc"
		}, {
			"name": "2",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/1e1344fabf25cf2ea6f1407cd42afc1f1de0bb07.gif",
			"uuid": "264f7a8d-475e-4fd0-ac83-96e13a7702f3"
		}, {
			"name": "8",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/90080b186e0507b70f64c2020880dd1ddd3b7cd8.gif",
			"uuid": "ec63930b-8aff-4108-9ceb-ddf9353d4412"
		}, {
			"name": "0",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/616a413facbd406b81daac809a52bd0b648a7f4c.gif",
			"uuid": "7c475d4d-0ae2-4b9a-81ff-76fb8264721f"
		}, {
			"name": "9",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/f41b70c1003ff703386a5a80ed7092db5fdc11f4.gif",
			"uuid": "473b82ec-c9b9-43d7-b2e5-b5399a55d239"
		}, {
			"name": "12",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/99660ca0a9a578cd6c5eb38b1f35aee9a77849b3.gif",
			"uuid": "84f549d3-9bb1-4066-9668-3705e94b5891"
		}, {
			"name": "11",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/f88c5de6bb6ab80f24cc56978e92cedf4af201f0.gif",
			"uuid": "a4470420-60bd-4578-a2dc-100663ba6256"
		}, {
			"name": "13",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/c5c446eba840899d364bcdb010a2aea8d2ae02ab.gif",
			"uuid": "7383d2db-43dd-408a-aa69-261bd39865ac"
		}, {
			"name": "6",
			"ext": ".gif",
			"url": "//yun.duiba.com.cn/aurora/881193ea1bd975c8a59f38f2d1f0d0094db6ec7a.gif",
			"uuid": "894a28f8-a814-4c8c-a5d9-619194b3073d"
		}, {
			"name": "btn-join",
			"ext": ".png",
			"url": "//yun.duiba.com.cn/aurora/e50e0fe70f4b2c96d2deee1d93a0a2444732be6a.png",
			"uuid": "e3301bc4-7b51-4868-a613-26298f87988b"
		}, {
			"name": "bg",
			"ext": ".jpg",
			"url": "//yun.duiba.com.cn/aurora/7dbe10dba2a92d830f0f9ff72f3d82e07a4c4649.jpg",
			"uuid": "bab58ec1-24b1-4d5d-9c95-7014b9915cb3"
		}, {
			"name": "1643017",
			"ext": ".png",
			"uuid": "54f7916f-dc10-49f7-b3b1-0bda9d4f5bcd",
			"url": "//yun.duiba.com.cn/aurora/4090d0acf7dbf29cd6ab0690795e0b00b715280c.png"
		}, {
			"name": "bg",
			"ext": ".png",
			"uuid": "5fe14ca0-5b86-405e-98a6-54ca733f2180",
			"url": "//yun.duiba.com.cn/aurora/070159098034ae2cd8c8e4bf4f47b1d45b87024a.png"
		}, {
			"name": "rule_button",
			"ext": ".png",
			"uuid": "82a9d493-078a-4b7c-8352-616abc99f24a",
			"url": "//yun.duiba.com.cn/aurora/d0c3ed2bf9abc5748c01eb88abb7e0830669b1c5.png"
		}, {
			"name": "wheel_items",
			"ext": ".png",
			"uuid": "b899e2f0-36da-42dc-a9ac-c8f4093e4457",
			"url": "//yun.duiba.com.cn/aurora/897ee802eb89999c2019c683c084f4b7e2d7f554.png"
		}, {
			"name": "wheel_bg",
			"ext": ".png",
			"uuid": "8f531f60-b48e-4a7a-bd7a-9488a3c3dd2d",
			"url": "//yun.duiba.com.cn/aurora/479cbb31bfdaee48893bf34f7d0c8fc702b1459a.png"
		}, {
			"name": "start_bg",
			"ext": ".png",
			"uuid": "62fe5f9b-47ec-4c1e-b508-f566501caa72",
			"url": "//yun.duiba.com.cn/aurora/3191ba684512b9e9391ab4a9d2a2df31cad4825d.png"
		}, {
			"name": "0",
			"ext": ".png",
			"uuid": "562af6d0-6b73-4de8-bed0-ed3a4507962c",
			"url": "//yun.duiba.com.cn/aurora/be2fa0d9e91b58d9aafcd18f7934784742069cb6.png"
		}, {
			"name": "1",
			"ext": ".png",
			"uuid": "6cf1bc08-bcc8-4cec-88d8-3e979b35dd0f",
			"url": "//yun.duiba.com.cn/aurora/3f64f753e272d17a1f5807ddf1a8965a0e2de9d5.png"
		}, {
			"name": "0",
			"ext": ".png",
			"uuid": "378851d3-6664-4b0e-8407-342f4ffaf334",
			"url": "//yun.duiba.com.cn/aurora/3c292a9c6c5b1a3dab684e95d1f7b7cb4f369a8a.png"
		}, {
			"name": "1",
			"ext": ".png",
			"uuid": "dee35c49-db44-4722-a412-a8b7123d20b7",
			"url": "//yun.duiba.com.cn/aurora/b22420f2322326359e2b3e1dae66dc7e34ce6978.png"
		}, {
			"name": "bg",
			"ext": ".png",
			"uuid": "2b0cc6bd-fc10-43ee-a217-aaf1c40a0ad3",
			"url": "//yun.duiba.com.cn/aurora/93fbb49529a3b4617f4cdc41dba7c297989baa5e.png"
		}],
	"dataMapping": [
		{name: 'nickname', path: 'test.hello.aaa.name'},
		{name: 'avatar', path: 'test.hello.aaa.avatar'},
	],
	processes: [
		{
			id: 'main',
			name: 'Main',
			props: {},
			subEntry: 'a1',
			sub: {
				a1: {
					uuid: 'a1',
					alias: '入口',
					meta: 'entry',
					output: {
						success: ['a2'],
					},
					design: {
						x: 10,
						y: 10,
					},
				},
				a2: {
					uuid: 'a2',
					alias: 'test',
					meta: 'test',
					props: {
						text: 'Hello',
					},
					output: {
						success: [],
						failed: [],
					},
					design: {
						x: 20,
						y: 100,
					},
				},
			}
		},
		{
			id: 'test',
			name: 'Test',
			desc: '测试过程',
			props: {
				text: {alias: '文本', type: 'string', default: '你好'},
				num: {alias: '数字', type: 'number', default: 1},
				type: {alias: '类型', type: 'enum', enum: ['rotate', 'jump', 'breath'], default: 'rotate'},
				autoPlay: {alias: '自动播放', type: 'boolean', default: false},
				color: {alias: '颜色', type: 'color', default: '#123456'},
				asset: {alias: '素材', type: 'asset',},
				node: {alias: '节点', type: 'node',},
			},
			output: ['success', 'failed'],
			script: "console.log('test');resolve({type: 'success'})",
		},
	],
};

const resp = {
	"success": true,
	"data": {
		"id": "6566c4a3f237",
		"name": "测试",
		"creator": "卞龙亭",
		"operator": "卞龙亭",
		"create_time": "2019-09-19T06:56:01.000Z",
		"update_time": "2019-09-19T06:56:01.000Z",
		"data": JSON.stringify(data),
	}
};

module.exports = function () {
	return resp;
};

//console.log(JSON.stringify(resp));
