'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

const replaceFields = ['page_title', 'container_id'];

async function pack(project, options) {
	let version = Date.now();
	let data = JSON.parse(project.data);
	const newTpl = await pageTemplate(data);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
		tpl: newTpl,
	}
}

async function packData(data, {getProcesses, getScripts}) {
	let newData = {};
	newData.options = data.options;
	delete newData.options.tpl;
	newData.views = data.views;
	newData.assets = data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;

	let scriptIDs = [];
	for (let view of newData.views) {
		traverseNode(view, (node) => {
			if (node.scripts && node.scripts.length > 0) {
				for (let {script} of node.scripts) {
					if (!scriptIDs.includes(script)) {
						scriptIDs.push(script);
					}
				}
			}
		});
	}
	//console.log('scriptIDs:', scriptIDs);
	let scriptsContainer = newData.scripts = {};
	if(scriptIDs.length > 0){
		const scripts = await getScripts(scriptIDs);
		for (let scriptData of scripts) {
			let {id, code} = JSON.parse(scriptData);
			scriptsContainer[id] = code;
		}
		//console.log('scripts:', scriptsContainer);
	}

	let processIDs = [];
	for (let process of newData.processes) {
		for (let key in process.sub) {
			let p = process.sub[key];
			if (!processIDs.includes(p.meta)) {
				processIDs.push(p.meta);
			}
		}
	}
	//console.log('processIDs:', processIDs);
	let builtinProcesses = newData.builtinProcesses = [];
	if(processIDs.length > 0){
		let processes = await getProcesses(processIDs);
		for (let processData of processes) {
			let process = JSON.parse(processData);
			builtinProcesses.push(process);
		}
		//console.log('processes:', data.processes);
	}

	return JSON.stringify(newData);
}

async function pageTemplate(data, options) {
	const {tpl,} = data.options;
	let newTpl = tpl;
	for (let field of replaceFields) {
		newTpl = newTpl.replace(`$${field.toUpperCase()}$`, data.options[field]);
	}
	return newTpl;
}

function traverseNode(root, callback) {
	callback(root);
	if (root.children && root.children.length > 0) {
		for (let childNode of root.children) {
			traverseNode(childNode, callback);
		}
	}
}

exports.pack = pack;
//# sourceMappingURL=index.js.map
