(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@babel/core'), require('zeroing-code-divider'), require('zeroing-template-fill')) :
	typeof define === 'function' && define.amd ? define(['exports', '@babel/core', 'zeroing-code-divider', 'zeroing-template-fill'], factory) :
	(global = global || self, factory(global['zeroing-pack'] = {}, global.babel, global.zeroingCodeDivider, global.zeroingTemplateFill));
}(this, function (exports, babel, zeroingCodeDivider, zeroingTemplateFill) { 'use strict';

	babel = babel && babel.hasOwnProperty('default') ? babel['default'] : babel;

	/**
	 * Created by rockyl on 2019-11-30.
	 */

	const UglifyJS = require('uglify-js');

	async function compile(source, debug = false) {
		const {code, map} = await babel.transformAsync(source, {
			presets: [
				['@babel/env', {}]
			],
			plugins: ["@babel/proposal-optional-chaining"],
			babelrc: false,
			sourceMaps: debug,
		});

		const result = {
			code,
		};
		if (map) {
			result.sourcemap = map.mappings;
		}
		return result;
	}

	function uglify(source){
		const uglifyResult = UglifyJS.minify(source, {
		});
		if (!uglifyResult.error) {
			return uglifyResult.code;
		}
	}

	/**
	 * Created by rockyl on 2019-11-13.
	 *
	 * 项目打包
	 */

	const replaceFields = ['pageTitle', 'containerId'];
	const TAG = 'zeroing-pack';

	async function pack(data, options) {
		let dependencies = data.dependencies;
		let getPackages = options.getPackages;

		const {libraryScriptElMap, analyseResult} = await zeroingTemplateFill.generateLibraryScriptEl(data.options.tpl, dependencies, getPackages, '//yun.duiba.com.cn/editor/zeroing/libs/');

		let version = Date.now() + Math.floor(Math.random() * 1000);
		pageTemplate(data, data.options, version, analyseResult, libraryScriptElMap);
		const newData = await packData(data, options);

		return {
			version,
			data: newData,
		}
	}

	function fillTpl(data, params) {
		const {options} = data;
		params.scripts = params.scripts.map(item => zeroingTemplateFill.generateJsScriptEl(item)).join('\n');
		options.newTpl = zeroingTemplateFill.fillTemplate(options.newTpl, params);

		const newTpl = options.newTpl;
		delete options.newTpl;
		return newTpl;
	}

	async function packData(data, {debug, packedAssets, getPackages}) {
		let newData = {};
		newData.options = data.options;
		newData.views = data.views;
		newData.assets = packedAssets || data.assets;
		newData.dataMapping = data.dataMapping;
		newData.processes = data.processes;
		newData.customs = data.customs;

		delete newData.options.tpl;
		deleteUnusedData(newData.processes);

		console.log(TAG, 'start');

		const {
			processScriptContent,
			scriptsContent,
			customScriptContent,
		} = await zeroingCodeDivider.divideCode(newData, {
			debug,
			uglify, compile,
			getPackages,
			dependencies: data.dependencies,
		});

		return {
			data: JSON.stringify(newData),
			processScriptContent,
			scriptsContent,
			customScriptContent,
		};
	}

	const unusedFields = ['design'];

	function deleteUnusedData(processes) {
		for (let process of processes) {
			if (process.sub) {
				for (let uuid in process.sub) {
					let subProcess = process.sub[uuid];
					for (let field of unusedFields) {
						if (subProcess.hasOwnProperty(field)) {
							delete subProcess[field];
						}
					}
				}
			}
			if (process.metas && process.metas.length > 0) {
				deleteUnusedData(process.metas);
			}
		}
	}

	function pageTemplate(tpl, options, version, analyseResult, libraryScriptElMap) {
		const params = {
			version,
			libraries: libraryScriptElMap,
		};
		for (let field of replaceFields) {
			params[field] = options[field];
		}

		options.newTpl = zeroingTemplateFill.fillTemplate(options.tpl, params, analyseResult);
	}

	exports.fillTpl = fillTpl;
	exports.pack = pack;

	Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=index.umd.js.map
