/**
 * Created by rockyl on 2019-11-29.
 */

export default class CustomManager {
	constructor() {
		this.pool = [];
	}

	deal(custom) {
		this.pool.push(custom);
	}

	generate(){
		let scripts = '';
		for(let {id, code} of this.pool){
			scripts += `
/*=====START ${id} START=====*/
module = {
	exports: {}
};
(function(module){
${code}
})(module);
exports['${id}'] = module.exports;
/*=====END ${id} END=====*/`;
		}

		return `
(function(){
var exports = {};
var module;

${scripts}

	for(var key in exports){
		engine.registerCustomModule(key, exports[key]);
	}
})();
`
	}
}
