/**
 * Created by rockyl on 2019-11-29.
 */

import crypto from 'crypto'
import {compile} from "./code-process";

function md5(source) {
	const hash = crypto.createHash('md5');
	return hash.update(source).digest('hex');
}

export default class ProcessManager {
	constructor() {
		this.pool = {};
		this.scripts = '';
	}

	deal(process) {
		let hash = this.put(process.script);
		if (hash) {
			process.script = 'link://' + hash;
		}
		if (process.metas) {
			for (let subProcess of process.metas) {
				let hash = this.put(subProcess.script);
				if (hash) {
					subProcess.script = 'link://' + hash;
				}
			}
		}
	}

	put(script) {
		if (script) {
			let hash = md5(script);
			if (!this.pool.hasOwnProperty(hash)) {
				this.pool[hash] = script;
			}
			return hash;
		}
	}

	async generateCurrent() {
		let scripts = '';
		for (let hash in this.pool) {
			let code = this.pool[hash];
			scripts += `
	exports['${hash}'] = function(args, props, target, global, vm){
		return new Promise(function(resolve, reject){

${code}

		function next(type, payload){resolve({type: type, payload: payload})}
		});
	};
`;
		}
		this.pool = {};

		console.log('scripts', scripts);

		try {
			const {code ,sourcemap} = await compile(scripts, true);
			this.scripts = code;
		}catch (e) {
			console.log('编译失败', e);
		}
	}

	generate() {
		let scripts = this.scripts;
		for (let hash in this.pool) {
			let code = this.pool[hash];
			scripts += `
	exports['${hash}'] = function(args, props, target, global, vm){
		return new Promise(function(resolve, reject){

${code}

		function next(type, payload){resolve({type: type, payload: payload})}
		});
	};
`;
		}

		return `
(function(){
var processScripts = {};
(function(exports){
${scripts}
})(processScripts);

	engine.setScriptMap(processScripts);
})();
`
	}
}
