'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var decamelize = _interopDefault(require('decamelize'));
var babel = _interopDefault(require('@babel/core'));
var zeroingCodeDivider = require('zeroing-code-divider');

/**
 * Created by rockyl on 2019-11-30.
 */

const UglifyJS = require('uglify-js');

async function compile(source, debug = false) {
	const {code, map} = await babel.transformAsync(source, {
		presets: [
			['@babel/env', {}]
		],
		babelrc: false,
		sourceMaps: debug,
	});

	const result = {
		code,
	};
	if (map) {
		result.sourcemap = map.mappings;
	}
	return result;
}

function uglify(source){
	const uglifyResult = UglifyJS.minify(source, {
	});
	if (!uglifyResult.error) {
		return uglifyResult.code;
	}
}

/**
 * Created by rockyl on 2019-11-13.
 *
 * 项目打包
 */

const replaceFields = ['pageTitle', 'containerId'];
const TAG = 'zeroing-pack';

async function pack(data, options) {
	let version = Date.now() + Math.floor(Math.random() * 1000);
	pageTemplate(data, data.options, version);
	const newData = await packData(data, options);

	return {
		version,
		data: newData,
	}
}

function fillTpl(data, params) {
	const {options} = data;
	fillTemplate(options.newTpl, options, params);

	const newTpl = options.newTpl;
	delete options.newTpl;
	return newTpl;
}

async function packData(data, {debug, packedAssets, getProcesses, getScripts, getCustoms}) {
	let newData = {};
	newData.options = data.options;
	newData.views = data.views;
	newData.assets = packedAssets || data.assets;
	newData.dataMapping = data.dataMapping;
	newData.processes = data.processes;
	newData.customs = data.customs;

	delete newData.options.tpl;
	deleteUnusedData(newData.processes);

	console.log(TAG, 'start');

	const {
		processScriptContent,
		scriptsContent,
		customScriptContent,
	} = await zeroingCodeDivider.divideCode(newData, {
		debug,
		uglify, compile,
		getProcesses, getScripts, getCustoms,
	});

	return {
		data: JSON.stringify(newData),
		processScriptContent,
		scriptsContent,
		customScriptContent,
	};
}

const unusedFields = ['design'];

function deleteUnusedData(processes) {
	for (let process of processes) {
		if (process.sub) {
			for (let uuid in process.sub) {
				let subProcess = process.sub[uuid];
				for (let field of unusedFields) {
					if (subProcess.hasOwnProperty(field)) {
						delete subProcess[field];
					}
				}
			}
		}
		if (process.metas && process.metas.length > 0) {
			deleteUnusedData(process.metas);
		}
	}
}

function pageTemplate(tpl, options, version) {
	const params = {
		version,
	};
	for (let field of replaceFields) {
		params[field] = options[field];
	}
	fillTemplate(options.tpl, options, params);
}

function fillTemplate(tpl, options, params) {
	for (let field in params) {
		const pattern = decamelize(field).toUpperCase();
		tpl = tpl.replace(new RegExp(`\\$${pattern}\\$`, 'g'), params[field]);
	}

	options.newTpl = tpl;
}

exports.fillTpl = fillTpl;
exports.pack = pack;
//# sourceMappingURL=index.js.map
