/**
 * Created by rockyl on 2020-04-07.
 *
 * 星速台环境变量处理
 */

import {env} from "./game-warpper/enviroment";
import {queryParams} from "./web";
import {httpRequest} from "../2d/net";
import {injectProp} from "./utils/utils";

export function dealPxEnv() {
	//appID提取
	if (queryParams.appID) {
		env.appID = queryParams.appID;
	}

	//渠道类型提取
	if (queryParams.channelType) {
		env.channelType = queryParams.channelType;
	}

	//projectID提取
	if (queryParams.projectID) {
		env.projectID = queryParams.projectID;
	} else {
		let result = window.location.pathname.match(/\/projectx\/(.*?)\/.*?/);
		if (result) {
			env.projectID = result[1];
		}
	}

	//是否是分享回流
	if (queryParams.is_from_share) {
		env.fromShare = true;
	}

	//新用户标记提取
	let newUser = true;
	let key = 'nu_' + env.appID + '_' + env.projectID;
	let v = localStorage.getItem(key);
	if (v) {
		newUser = false;
	} else {
		localStorage.setItem(key, '1');
	}
	env.newUser = newUser;

	if (window['isSharePage']) {
		accessLog(506);
	}
}

export function cleanNewUser(){
	let key = 'nu_' + env.appID + '_' + env.projectID;
	localStorage.removeItem(key);
}

export function dealPageRemainTime() {
	let startTimer = new Date().getTime();
	let endTimer;
//设置隐藏属性和改变可见属性的事件的名称
	let visibilityChange;
	if (typeof document.hidden !== 'undefined') {
		visibilityChange = 'visibilitychange';
	} else if (typeof document['msHidden'] !== 'undefined') {
		visibilityChange = 'msvisibilitychange';
	} else if (typeof document['webkitHidden'] !== 'undefined') {
		visibilityChange = 'webkitvisibilitychange';
	}

	const handleVisibilityChange = (e) => {
		if (document.visibilityState == "visible") {
			startTimer = new Date().getTime();
			//console.log('starttimer', startTimer)
		}

		if (document.visibilityState == "hidden") {
			endTimer = new Date().getTime();
			//console.log('endTimer', endTimer);
			sendData();
		}
	};
	const sendData = () => {
		const t0 = endTimer - startTimer;

		//console.log('duration', t0);

		accessLog(156, {
			remain: t0,
		});
	};

	document.addEventListener(
		visibilityChange,
		handleVisibilityChange,
		false
	);

	document.body['onbeforeunload'] = () => {
		endTimer = new Date().getTime();
		return sendData();
	}
}

export function accessLog(pagebizid, params?) {
	let p = {
		pagebizid,
	};
	injectProp(p, params);
	return httpRequest('buriedPoint', 'get', p);
}
