/**
 * Created by rockyl on 2019-11-08.
 */

import {Stage} from "../2d/display";
import {registerCustomModuleFromConfig, registerScripts, RENDERER_TYPE, setProcessMetaLibs, StageScaleMode} from "..";
import {GameStage} from "./game-warpper/index";
import {setGlobalContext} from "./behavior-runtime";
import {globalLoader} from "../2d/loader/Loader";
import {Event} from "../2d/events/Event";
import builtinLoadingView from "./game-warpper/LoadingView";
import {queryParams} from "./web";
import {initAutoLayout} from "./game-warpper/auto-layout";

export let gameStage: GameStage;

export function launch(url, loadingDelegate?, onStart?) {
	if (queryParams.__proxy_mode__) {
		return Promise.resolve('cancel launch');
	}
	return globalLoader.loadJson(url)
		.then(config => {
			return launchWithConfig(config, loadingDelegate, onStart);
		});
}

export function launchWithLocalStorage(id, loadingDelegate?, onStart?) {
	const storeKey = 'preview-project-' + id;
	let storeData = localStorage.getItem(storeKey);
	let {data, processes, scripts, customs,} = JSON.parse(storeData);

	setProcessMetaLibs(processes);
	registerScripts(scripts);
	registerCustomModuleFromConfig(customs);

	return launchWithConfig(data, loadingDelegate, onStart);
}

export function launchWithWindowVariable(name, loadingDelegate?, onStart?) {
	let {data, processes, scripts, customs,} = window[name];

	setProcessMetaLibs(processes);
	registerScripts(scripts);
	registerCustomModuleFromConfig(customs);

	return launchWithConfig(data, loadingDelegate, onStart);
}

export async function launchWithConfig(config, loadingDelegate?, onStart?) {
	await new Promise(resolve => {
		setTimeout(resolve, 300);
	});
	return await new Promise(resolve => {
		const {containerId, designWidth, designHeight, frameRate, scaleMode, rendererType,} = config.options;
		let stage = window['stage'] = new Stage(
			containerId || "game-container",
			designWidth || 750,
			designHeight || 1334,
			frameRate || 60,
			scaleMode || StageScaleMode.FIXED_WIDTH,
			rendererType || RENDERER_TYPE.WEBGL,
		);
		initAutoLayout(stage);
		Stage.flushAll();

		stage.addEventListener(Event.ON_INIT_STAGE, () => {
			gameStage = new GameStage(stage);
			setGlobalContext({
				gameStage
			});
			stage.addChild(gameStage);

			let delegate = loadingDelegate || builtinLoadingView;

			gameStage.launch(config, function (done, total) {
				delegate.onProgress && delegate.onProgress(done, total)
			}, function () {
				delegate.onComplete && delegate.onComplete();
			}, onStart);
		});

		resolve(gameStage);
	})
}
