/**
 * Created by rockyl on 2019-11-08.
 */

import {Node, Rect, Image, Label, Circle, ScrollView, TextInput, ScrollList, BitmapText, HtmlView} from "./nodes/index";
import {injectProperties, instantiateScript,} from "../utils/index";

const nodeTypeMapping = {
	node: Node,
	rect: Rect,
	circle: Circle,
	label: Label,
	image: Image,
	textinput: TextInput,
	scrollView: ScrollView,
	scrollList: ScrollList,
	bitmapText: BitmapText,
	htmlView: HtmlView,
};

export function registerNodeType(name, def) {
	nodeTypeMapping[name] = def;
}

export function instantiate(config) {
	return instantiateView(config);
}

function instantiateView(config) {
	const {type} = config;

	const nodeTypeDef = nodeTypeMapping[type];
	if (!nodeTypeDef) {
		console.warn('error node type:', type);
		return;
	}

	const node = new nodeTypeDef();
	const {name, uuid, properties, children, events, scripts} = config;
	node.name = name;
	node.uuid = uuid;
	node.__originConfig = config;
	injectProperties(node, properties);

	if (children && children.length > 0) {
		for (let childConfig of children) {
			const childNode = instantiateView(childConfig);
			if (childNode) {
				node.addChild(childNode);
			}
		}
	}

	if (scripts && scripts.length > 0) {
		for (let scriptConfig of scripts) {
			instantiateScript(node, scriptConfig);
		}
	}
	if (events && node.eventsProxy) {
		node.eventsProxy.start(events);
	}

	return node;
}
