/**
 * Created by rockyl on 2019-12-16.
 */
import {getAssetByUUID} from "./assets-manager";
import {Howl, Howler} from 'howler';
import {injectProperties} from "../utils";

const instances = {};

export function playSound(uuid, options: any = {}, name?) {
	let assetConfig = getAssetByUUID(uuid);
	if (assetConfig) {
		let url = assetConfig.url;

		let opts: any = {
			src: [url],
			autoplay: false,
		};

		injectProperties(opts, options);

		const key = name || uuid;

		const {keep = false} = opts;

		let sound;
		if (keep) {
			const data = instances[key];
			if (data) {
				sound = data.sound;
			}
		}
		if (!sound) {
			sound = new Howl(opts);
		}

		instances[key] = {
			sound,
			keep,
		};
		if (!keep) {
			sound.on('stop', function () {
				destroySound(key);
			});
		}

		sound.play();

		return sound;
	}
}

export function stopSound(name) {
	let instance = instances[name];
	if (instance) {
		const {sound, keep} = instance;
		sound.stop();
	}
}

export function destroySound(name) {
	delete instances[name];
}

export function mute(muted = true) {
	Howler.mute(muted)
}

export function preloadSound(url, uuid) {
	let sound = new Howl({
		src: url,
		preload: true,
	});

	instances[uuid] = {
		sound,
		keep: true,
	};
}
