/**
 * Created by rockyl on 2019-11-06.
 */
import Color from "color";
import {Event} from "../../../2d/events";
import {dirtyFieldDetector} from "../../decorators";
import Graphics from "../../../2d/graphics/Graphics";
import {Container} from "../../../2d/display/index";
import {IUIComponent} from "./IUIComponent";

/**
 * 图形基类
 */
class ShapeBase extends Graphics implements IUIComponent {
	isUI = true;

	protected __fieldDirty = true;

	@dirtyFieldDetector
	fillColor: any = 'white';
	@dirtyFieldDetector
	strokeColor: any = 0;
	@dirtyFieldDetector
	strokeWidth: number = 0;

	constructor() {
		super();

		this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this);
		this.addEventListener(Event.RESIZE, this.onResize, this);
	}

	private onResize(e) {
		this.__fieldDirty = true;
	}

	private onEnterFrame(e) {
		if (this.__fieldDirty) {
			this.__fieldDirty = false;

			const {fillColor, strokeColor, strokeWidth} = this;

			this.clear();
			this.beginFill(new Color(fillColor).rgbNumber());
			if (strokeWidth > 0) {
				this.lineStyle(strokeWidth, new Color(strokeColor).rgbNumber());
			}
			this.redraw();
			this.endFill();
		}
	}

	protected redraw() {

	}
}

/**
 * 矩形
 */
export class Rect extends ShapeBase {
	@dirtyFieldDetector
	borderRadius: number = 0;

	protected redraw() {
		const {width, height, borderRadius,} = this;

		if (borderRadius > 0) {
			this.drawRoundedRect(0, 0, width, height, borderRadius);
		} else {
			this.drawRect(0, 0, width, height);
		}
	}
}

/**
 * 圆形
 */
export class Circle extends ShapeBase {
	protected redraw() {
		super.redraw();

		const {width, height} = this;
		const radius = Math.min(width, height) / 2;

		this.drawCircle(radius, radius, radius);
	}
}
