/**
 * Created by rockyl on 2019-11-24.
 */

import {ScrollViewBase} from "../../../2d/ui/ScrollViewBase";
import {Container} from "../../../2d/display/index";
import {IUIComponent} from "./IUIComponent";

export const proxyMethods = [
	'onChildrenChange',
	'addChild',
	'addChildAt',
	'swapChildren',
	'getChildIndex',
	'setChildIndex',
	'getChildAt',
	'getChildByName',
	'removeChild',
	'removeChildAt',
	'removeChildren',
];

export class ScrollView extends ScrollViewBase implements IUIComponent {
	isUI = true;

	constructor() {
		super();

		for(let item of proxyMethods){
			this[item] = this.viewPort[item].bind(this.viewPort);
		}
	}
}

