/**
 * Created by rockyl on 2019-11-24.
 */

import {ScrollListBase, ScrollListItemBase} from "../../../2d/ui/ScrollListBase";
import {Event} from "../../../2d/events";
import {proxyMethods} from "./ScrollView";
import Container from "../../../2d/display/Container";
import {IUIComponent} from "./IUIComponent";

export class ScrollListItem extends ScrollListItemBase implements IUIComponent {
	isUI = true;

	view: Container;

	setView(view) {
		this.addChild(view);
		this.view = view;
	}

	updateData(data: any): void {
		this.view['data'] = data;
		this.view.dispatchEvent(Event.UPDATE_DATA, data);
	}
}

export class ScrollList extends ScrollListBase {
	firstItem: Container;
	cloneEvents: boolean = true;
	cloneScripts: boolean = true;

	constructor() {
		super();

		this.itemClass = ScrollListItem;

		for (let item of proxyMethods) {
			this[item] = this.viewPort[item].bind(this.viewPort);
		}
	}

	protected onNextFrame(event) {
		this.firstItem = <Container>this.removeChildAt(0);
		this.updateViewRect();
	}

	protected createItem(): any {
		let item = <ScrollListItem>super.createItem();
		item.setView(this.firstItem.clone(this.cloneEvents, this.cloneScripts));

		return item;
	}
}
