/**
 * Created by rockyl on 2019-11-08.
 */
import {TextField} from "../../../2d/text/index";
import {dataCenter} from "../data-center";
import {ESCAPE_REG_EXP, htmlToPureText} from "../../utils/index";
import {Container} from "../../../2d/display/index";
import {IUIComponent} from "./IUIComponent";

/**
 * 文本
 */
export class Label extends TextField implements IUIComponent {
	isUI = true;

	private _originText;
	private _escapes = [];
	private _registeredEvents = [];
	private _htmlText;

	/**
	 * 重载文本设置
	 * @param value
	 * @private
	 */
	protected _setText(value) {
		if (typeof value !== 'string') {
			value = value + '';
		}
		if (value !== this._text) {
			let matchResult = value.match(ESCAPE_REG_EXP);

			if (matchResult) {
				this.dealEscape(value, matchResult, this.onTextMutated);
			} else {
				super._setText(value);
			}
		}
	}

	private dealEscape(value, matchResult, onMutated) {
		this.unregisterEvents();
		this._originText = value;
		this._escapes.splice(0);
		for (let item of matchResult) {
			let escape = item.substr(2, item.length - 3);
			let args = escape.split('|');
			let eventName = args[0];
			this._escapes.push(escape);
			dataCenter.addEventListener(eventName, onMutated, this);
			this._registeredEvents.push(eventName);
		}
		onMutated();
	}

	get htmlText() {
		return this._htmlText;
	}

	/**
	 * 设置html文本
	 */
	set htmlText(value) {
		if (this._htmlText != value) {
			this._htmlText = value;

			if(this._htmlText){
				let matchResult = value.match(ESCAPE_REG_EXP);

				if (matchResult) {
					this.dealEscape(value, matchResult, this.onHtmlMutated);
				} else {
					this.text = htmlToPureText(value);
				}
			}
		}
	}

	/**
	 * 把之前侦听的全部移除
	 */
	private unregisterEvents() {
		for (let item of this._registeredEvents) {
			dataCenter.removeEventListener(item, this.onTextMutated, this);
		}
		this._registeredEvents.splice(0);
	}

	/**
	 * 当TEXT改变时
	 * @param e
	 */
	private onTextMutated = (e = null) => {
		super._setText(dataCenter.formatString(this._originText, this._escapes));
	}

	/**
	 * 当HTML改变时
	 * @param e
	 */
	private onHtmlMutated = (e = null) => {
		let html = dataCenter.formatString(this._originText, this._escapes);
		this.text = htmlToPureText(html);
	}
}
