/**
 * Created by rockyl on 2019-11-07.
 */
import {Sprite} from "../../../2d/display/index";
import Texture from "../../../2d/texture/Texture";
import {getAssetByName, getAssetByUUID} from "../assets-manager";
import {dataCenter} from "../data-center";
import {ESCAPE_REG_EXP} from "../../utils/index";
import {Event} from "../../../2d/events/index";
import {Container} from "../../../2d/display/index";
import {IUIComponent} from "./IUIComponent";

const assetScheme = 'asset://';

export class Image extends Sprite implements IUIComponent {
	isUI = true;

	crossOrigin = true;

	private _originText;
	private _escapes = [];
	private _registeredEvents = [];

	private _source: string;

	get source() {
		return this._source;
	}

	set source(v) {
		if (this._source !== v) {
			this._setSource(v);
		}
	}

	private updateSource() {
		let url = this._source;
		if (url) {
			if (url.indexOf('://') >= 0) { //如果是有协议的地址
				if (url.indexOf(assetScheme) === 0) {
					url = url.replace(assetScheme, '');
					/*const assetConfig = getAssetByUUID(uuid);
					if(assetConfig){
						url = assetConfig.url;
						this.texture = Texture.fromImage(url);
					}*/
				}
			} else { //否则就使用素材名
				const assetConfig = getAssetByName(url);
				if (assetConfig) {
					url = assetConfig.uuid;
				}
			}
			this.texture = Texture.fromImage(url, this.crossOrigin);
		} else {
			this.texture = null;
		}
	}

	private _setSourceDirect(value) {
		this._source = value;
		this.updateSource();

		this.dispatchEvent(Event.RESIZE);
	}

	private _setSource(value) {
		if (value !== this._source) {
			if (value) {
				let matchResult = value.match(ESCAPE_REG_EXP);

				if (matchResult) {
					this.unregisterEvents();
					this._originText = value;
					this._escapes.splice(0);
					for (let item of matchResult) {
						let escape = item.substr(2, item.length - 3);
						let args = escape.split('|');
						let eventName = args[0];
						this._escapes.push(escape);
						dataCenter.addEventListener(eventName, this.onDataMutated, this);
						this._registeredEvents.push(eventName);
					}
					this.onDataMutated();
				} else {
					this._setSourceDirect(value);
				}
			} else {
				this._setSourceDirect(value);
			}
		}
	}

	/**
	 * 把之前侦听的全部移除
	 */
	private unregisterEvents() {
		for (let item of this._registeredEvents) {
			dataCenter.removeEventListener(item, this.onDataMutated, this);
		}
		this._registeredEvents.splice(0);
	}

	/**
	 * 当数据改变时
	 * @param e
	 */
	private onDataMutated(e = null) {
		this._setSourceDirect(dataCenter.formatString(this._originText, this._escapes));
	}
}
