/**
 * Created by rockyl on 2020-01-07.
 */

import {Container, FloatDisplay} from "../../../2d/display/index";
import {afterConstructor} from "../../decorators/after-constructor";
import {applyAutoAdjust} from "../../decorators/auto-adjust";
import {applyScript} from "../../decorators/scripts";
import {applyEvents} from "../../decorators/events";
import {IUIComponent} from "./IUIComponent";

@afterConstructor
@applyAutoAdjust
@applyScript
@applyEvents
export class HtmlView extends FloatDisplay implements IUIComponent{
	isUI = true;

	constructor() {
		super();

		this.afterConstructor();
	}

	afterConstructor() {

	}

	get $store() {
		let p = this;
		do {
			if (p['$isViewRoot']) {
				break;
			}
			p = p.parent;
		}
		while (p.parent);

		if (p) {
			return p['$_store'];
		}
	}

	/**
	 * 根据uuid搜索子节点
	 * @param uuid
	 */
	findChildByUUID(uuid: string) {
		if (this['uuid'] === uuid) {
			return this;
		}
	}
}
