/**
 * Created by rockyl on 2019-12-27.
 */

import Container from "../../../2d/display/Container";
import Sprite from "../../../2d/display/Sprite";
import Texture from "../../../2d/texture/Texture";
import {getFont} from "../bmp-text-manager";
import {dirtyFieldTrigger} from "../../decorators";
import {VERTICAL_ALIGN} from "../../../2d/const";
import {IUIComponent} from "./IUIComponent";

export class BitmapText extends Container implements IUIComponent {
	isUI = true;

	private _charCache = [];
	private _fontConfig;

	@dirtyFieldTrigger
	public text: string = '';
	@dirtyFieldTrigger
	public font: string;
	@dirtyFieldTrigger
	public verticalAlign: VERTICAL_ALIGN = VERTICAL_ALIGN.DOWN;
	@dirtyFieldTrigger
	public letterSpacing: number = 0;

	onModify(value, key) {
		switch (key) {
			case 'text':
			case 'letterSpacing':
			case 'verticalAlign':
				this.render();
				break;
			case 'font':
				this._fontConfig = getFont(value);
				break;
		}
	}

	protected render() {
		if (!this._fontConfig || !this.text) {
			return;
		}

		let text = this.text + '';

		let x = 0, li = text.length, maxHeight = 0;
		for (let i = 0; i < li; i++) {
			const char = text[i];
			let sp = this.addChar(char, i);
			sp.x = x;
			x += sp.width + this.letterSpacing;
			if (sp.height > maxHeight) {
				maxHeight = sp.height;
			}
		}
		for (let j = li, lj = this.children.length; j < lj; j++) {
			this._charCache.push(this.removeChildAt(j));
			j--;
			lj--;
		}

		if (this._height) {
			maxHeight = this._height;
		}
		for (let i = 0, li = this.children.length; i < li; i++) {
			const child = this.children[i];
			switch (this.verticalAlign) {
				case VERTICAL_ALIGN.DOWN:
					child.y = maxHeight - child.height;
					break;
				case VERTICAL_ALIGN.MIDDLE:
					child.y = (maxHeight - child.height) / 2;
					break;
				case VERTICAL_ALIGN.UP:
					child.y = 0;
					break;
			}
		}
	}

	private addChar(char, index) {
		let sp: Sprite = <Sprite>this.getChildAt(index);
		if (!sp) {
			if (this._charCache.length > 0) {
				sp = this._charCache.pop();
			} else {
				sp = new Sprite();
			}
		}
		if (!sp.parent) {
			this.addChild(sp);
		}
		let uuid = this._fontConfig[char];
		if (!uuid) {
			console.log(`font asset not found: [${char}] in`, this.font);
		}
		sp.texture = uuid ? Texture.fromImage(uuid) : null;
		return sp;
	}
}
