/**
 * Created by rockyl on 2020-03-02.
 */

import {Zri} from "./Zri";
import {Compiler, IZri, ZriOptions} from "./Interfaces";
import {ZriCompiler} from "./ZriCompiler";
import {Container} from "../../../2d/display/index";
import {safeEval} from "../../utils/utils";

/**
 * 将数据模型和视图进行绑定
 * @param store 数据
 * @param view 视图
 * @param options 一些额外参数
 * @returns {IZri} 绑定实体对象
 */
export function bind(store: any, view: Container, options?: ZriOptions): IZri {
	let compiler = new ZriCompiler(view);
	let zri = new Zri(store, compiler, options);
	compiler.debug();
	return zri;
}

/**
 * 通过配置生成数据
 * @param exp
 * @param computed
 */
export function createStore(exp, computed) {
	let store = safeEval(exp) || {};
	for (let {name, script} of computed) {
		if (name && !store.hasOwnProperty(name)) {
			let getterCode = `return function(){
			${script}
		}`;
			Object.defineProperty(store, name, {
				get: safeEval(getterCode),
			})
		}
	}
	return store;
}
