/**
 * Created by rockyl on 2020-03-19.
 */
import {Compiler, IZri, ZriCommandData} from "./Interfaces";
import {Container,} from "../../../2d/display/index";
import {Command, commands, CommandContext} from "./ZriCommands";
import {cmdPrefix} from "../../utils/utils";

const interruptCmds = ['for', 'if'];

export class ZriCompiler implements Compiler {
	private _root: Container;
	private _entity: IZri;

	constructor(root: Container) {
		this._root = root;
	}

	get root(): Container {
		return this._root;
	}

	init(entity: IZri): void {
		this._entity = entity;
		this.compile(this._root, entity.data);
	}

	//props = [];

	compile(target: any, scope: any): void {
		let cmdDatas = [];
		let needInterrupt = false;
		let originConfig = target['__originConfig'];
		if (originConfig && originConfig.properties) {
			let properties = originConfig.properties;
			let props = [];
			for (let key in properties) {
				if (key.indexOf(cmdPrefix) != 0) {
					continue;
				}
				//props.push(key);
				let cmdData = this._entity.parseCommand(key, target[key]);
				if (cmdData) {
					cmdDatas.push(cmdData);
					if (interruptCmds.indexOf(cmdData.cmdName) >= 0) {
						needInterrupt = true;
						cmdDatas.splice(0, cmdDatas.length - 1);
						break;
					}
				}
			}
			for (let cmdData of cmdDatas) {
				delete target[cmdData.propName];
				if (interruptCmds.indexOf(cmdData.cmdName) >= 0) {
					delete properties[cmdData.propName];
				}
				let cmd: Command = commands[cmdData.cmdName];
				if (!cmd) {
					cmdData.subCmd = cmdData.cmdName || "";
					cmdData.cmdName = "prop";
					cmd = commands[cmdData.cmdName];
				}
				cmd({
					scope,
					target,
					entity: this._entity,
					cmdData,
					compiler: this,
				})
			}

			/*if(props.length > 0){
				this.props.push(props);
			}*/
		}
		if (!needInterrupt && target.children && target.children.length > 0) {
			for (let child of target.children) {
				this.compile(child, scope);
			}
		}
	}

	debug() {
		//console.log(this.props);
	}
}
