/**
 * Created by rockyl on 2019-11-22.
 */
import {arrayFind, importCJSCode, linkScheme} from "../utils";
import {Container} from "../../2d/display";
import {getAssetByUUID} from "./assets-manager";

const customMap = {};

/**
 * 注册自定义模块素材映射
 * @param customs
 */
export function registerCustomModules(customs) {
	if(!customs){
		return;
	}
	for (let custom of customs) {
		if(custom.assets){
			customMap[custom.id].assets = custom.assets;
		}
		if(custom.props){
			customMap[custom.id].props = custom.props;
		}
	}
}

/**
 * 注册自定义模块
 * @param id
 * @param def
 */
export function registerCustomModule(id, def) {
	customMap[id] = {
		def,
	};
}

/**
 * 注册自定义模块代码段
 * @param config
 */
export function registerCustomCodeModule(config) {
	const {id, code} = config;
	registerCustomModule(id, importCJSCode(code, true));
}

/**
 * 通过配置注册自定义模块
 * @param config
 */
export function registerCustomModuleFromConfig(config) {
	if (config) {
		for (let item of config) {
			registerCustomCodeModule(item);
		}
	}
}

/**
 * 增加自定义模块
 * @param id
 * @param container
 * @param options
 */
export function addCustomModule(id, container: Container, options?) {
	let creator = customMap[id].def;
	if (creator) {
		let instance = creator(options);
		if (instance) {
			container.addChild(instance);
			return instance;
		}
	}
}

/**
 * 处理自定义模块资源
 * @param id
 * @param uuid
 */
export function resolveCustomAsset(id, uuid) {
	let module = customMap[id];
	if (module) {
		let config = arrayFind(module.assets, item => item.uuid === uuid);
		if (config) {
			if (config.url.indexOf(linkScheme) === 0) {
				let linkUUID = config.url.replace(linkScheme, '');
				let linkConfig = getAssetByUUID(linkUUID);
				if (linkConfig) {
					config = linkConfig;
				}
			}
		}
		return config;
	}
}

/**
 * 获取配置参数
 * @param id
 */
export function getProps(id) {
	return customMap[id].props || {};
}
