/**
 * Created by rockyl on 2019-12-27.
 */

const prefix = 'font-';

const fonts = {};

/**
 * 从图集转换
 * @param sheet
 */
export function parseSheet(sheet) {
	for (let uuid in sheet) {
		let config = sheet[uuid];
		parseAssetConfig(config, uuid);
	}
}

export function parseAssetConfig(assetConfig, uuid?) {
	if (assetConfig.name && assetConfig.name.indexOf(prefix) === 0) {
		let fontName = assetConfig.name.replace(prefix, '');
		let arr = fontName.split('|');
		fontName = arr[0];
		let fontChar = arr[1];

		let font = fonts[fontName];
		if (!font) {
			font = fonts[fontName] = {};
		}
		font[fontChar] = uuid || assetConfig.uuid;
	}
}

export function parse(assetConfig, data) {
	switch (assetConfig.ext) {
		case '.png':
			parseAssetConfig(assetConfig);
			break;
		case '.sht':
			parseSheet(data.frames);
			break;
	}
}

export function getFont(name) {
	return fonts[name];
}
