/**
 * Created by rockyl on 2020-03-03.
 */

import {Stage} from "../../2d/display/Stage";
import {Event} from "../../2d/events/Event";
import {traverseViewNode} from "../utils/utils";
import {isUI} from "./nodes/IUIComponent";

let _stage: Stage;

export function initAutoLayout(stage: Stage) {
	_stage = stage;

	_stage.addEventListener(Event.LAYOUT_INVALID, onLayoutInvalid)
}

function onLayoutInvalid() {
	console.time('adjustLayout');
	//traverseViewNode(_stage, adjustLayout, true);
	let layoutTree = duplicateLayoutTree(_stage);
	console.log(layoutTree);
	console.timeEnd('adjustLayout');
}

function duplicateLayoutTree(node) {
	let tree = {};

	getLayoutTreeOnce(node, tree, true);

	return tree;
}

function getLayoutTreeOnce(node, tree, includeSelf = false) {
	if (includeSelf) {
		tree.name = node.name;
		tree.frame = node.frame;
		tree.constraint = node.adjustProxy.data;
		tree.children = [];

		if (node.isUI) {
			tree.isUI = true;
		}
	}

	for (let child of node.children) {
		let layoutNode: any = {
			name: child.name,
			frame: child.frame,
			constraint: child.adjustProxy.data,
			children: [],
		};
		if (child.isUI) {
			layoutNode.isUI = true;
		}
		tree.children.push(layoutNode);

		if (child.children && child.children.length > 0) {
			getLayoutTreeOnce(child, layoutNode);
		}
	}
}

function adjustLayout(node) {
	if (!isUI(node)) {
		return;
	}

	const {width, height, parent: {width: pWidth, height: pHeight},} = node;
	const {percentWidth, percentHeight, left, top, right, bottom, horizonCenter, verticalCenter} = node;

	const applyPercentWidth = function () {
		if (t(percentWidth)) {
			node.width = pWidth * percentWidth / 100;
			return true;
		}
	};
	const applyPercentHeight = function () {
		if (t(percentHeight)) {
			node.height = pHeight * percentHeight / 100;
			return true;
		}
	};

	let pw = true, ph = true;
	if (t(horizonCenter)) {
		pw = applyPercentWidth();
		node.x = (pWidth - node.width) / 2 + horizonCenter;
	} else {
		if (t(left)) {
			node.x = left;
			if (t(right)) {
				node.width = pWidth - left - right;
				pw = false;
			}
		} else if (t(right)) {
			node.x = pWidth - width - right;
		}
		if (pw) {
			pw = applyPercentWidth();
		}
	}
	if (!pw) {
		node.dispatchEvent(Event.RESIZE);
	}

	if (t(verticalCenter)) {
		applyPercentHeight();
		node.y = (pHeight - node.height) / 2 + verticalCenter;
	} else {
		if (t(top)) {
			node.y = top;
			if (t(bottom)) {
				node.height = pHeight - top - bottom;
				ph = false;
			}
		} else if (t(bottom)) {
			node.y = pHeight - height - bottom;
		}
		if (ph) {
			applyPercentHeight();
		}
	}
}

function t(v) {
	return !isNaN(v) && v !== null && v !== undefined;
}
