/**
 * Created by rockyl on 2019-11-07.
 */

import {globalLoader} from "../../2d/loader/Loader";
import {arrayFind, linkScheme} from "../utils";
import {parse} from "./bmp-text-manager";

let assetsConfig = [];

const loaderMapping = {
	'.png': 'Texture',
	'.jpg': 'Texture',
	'.jpeg': 'Texture',
	'.gif': 'Texture',
	'.svg': 'Texture',
	'.txt': 'Text',
	'.json': 'Json',
	'.svga': 'Svga',
	'.sht': 'Sheet',
	'.mp3': 'Sound',
	'': 'Raw',
};

/**
 * 加载素材
 */
export function loadAssets(config, onProgress?, onComplete?) {
	let total = config.length;
	let loaded = 0;
	let failedList = [];

	return Promise.all(
		config.map(assetConfig => {
			assetsConfig.push(assetConfig);
			const {url, ext, uuid} = assetConfig;
			const loadFunc = loaderMapping[ext];
			if (loadFunc) {
				if(url.indexOf(linkScheme) === 0){
					loaded++;
					onProgress && onProgress(loaded, total);
					return Promise.resolve();
				}
				let method = globalLoader['load' + loadFunc];
				return method.call(globalLoader, url, uuid).then(
					(data) => {
						parse(assetConfig, data);

						loaded++;
						onProgress && onProgress(loaded, total);
					},
					(error) => {
						failedList.push(url);
					}
				);
			} else {
				loaded++;
				onProgress && onProgress(loaded, total);
				return Promise.resolve();
			}
		})
	).then(
		() => {
			if (loaded < total) {
				return Promise.reject('some asset can not loaded: ' + failedList.join(', '));
			} else {
				onComplete && onComplete();
			}
		}
	)
}

/**
 * 根据uuid获取素材配置
 * @param uuid
 */
export function getAssetByUUID(uuid): any {
	let result = arrayFind(assetsConfig, item => item.uuid === uuid);
	if (result) {
		return result;
	} else {
		for (let assetConfig of assetsConfig) {
			let res = globalLoader.get(assetConfig.url);
			if (res && res.frames) {
				for (let key in res.frames) {
					if (key === uuid) {
						return {uuid: key};
					}
				}
			}
		}
	}
}

/**
 * 根据name获取素材配置
 * @param name
 */
export function getAssetByName(name): any {
	let result = arrayFind(assetsConfig, item => item.name === name);
	if (result) {
		return result;
	} else {
		for (let assetConfig of assetsConfig) {
			let res = globalLoader.get(assetConfig.url);
			if (res && res.frames) {
				for (let key in res.frames) {
					const frame = res.frames[key];
					if (frame.name === name) {
						return {uuid: key};
					}
				}
			}
		}
	}
}
