/**
 * Created by rockyl on 2019-11-25.
 */

import {GameStage} from "./GameStage";
import {Label, Rect, Node} from "./nodes/index";
import {Tween} from "../../2d/tween/index";

export class Toast extends Node {
	private _contentSample: Node;
	private _content: Node;

	private _gameStage: GameStage;

	name = 'toast';

	constructor(gameStage: GameStage) {
		super();
		this._gameStage = gameStage;
		this.mouseEnabled = this.mouseChildren = false;

		this.horizonCenter = 0;
		this.verticalCenter = 0;
	}

	show(props: any = {}) {
		if (!props.text) {
			return;
		}

		let contentView = this.getContent(props.viewName);
		let lab = contentView.getChildByName('lab');
		if (!lab) {
			console.warn('[lab] child no exists on toast view');
			return;
		}
		const {text, padding = 10, duration = 1000, showDuration = 300, hideDuration = 200} = props;

		lab.text = text;
		lab.x = lab.y = padding;
		this.width = contentView.width = lab.width + padding * 2;
		this.height = contentView.height = lab.height + padding * 2;

		if (!contentView.visible) {
			contentView.visible = true;
			contentView.alpha = 0;
		}
		Tween.get(contentView, null, null, true)
			.to({alpha: 1}, showDuration)
			.wait(duration)
			.to({alpha: 0}, hideDuration)
			.call(this.removeContentView, this)
	}

	hide(animation = true, hideDuration = 200) {
		if (this._content) {
			const contentView = this._content;
			if(animation){
				Tween.get(contentView, null, null, true)
					.to({alpha: 0}, hideDuration)
					.call(this.removeContentView, this)
			}else{
				Tween.removeTweens(contentView);
				this.removeContentView();
			}
		}
	}

	private removeContentView() {
		this._content.visible = false;
		this.removeChild(this._content);
		this._content = null;
	}

	private getContent(viewName) {
		let view;

		if (this.children.length == 0) {
			if (viewName) {
				view = this._gameStage.instantiateView(viewName);
			}
			if (!view) {
				if (!this._contentSample) {
					this._contentSample = new Node();
					let bg = new Rect();
					bg.borderRadius = 10;
					bg.percentWidth = 100;
					bg.percentHeight = 100;
					bg.fillColor = 'black';
					bg.alpha = 0.7;
					this._contentSample.addChild(bg);
					let lab = new Label();
					lab.name = 'lab';
					lab.fillColor = 'white';
					lab.size = 30;
					this._contentSample.addChild(lab);
				}
				view = this._contentSample;
			}
			this._content = view;
			this.addChild(view);
		} else {
			view = this.getChildAt(0);
		}

		return view;
	}
}
