/**
 * Created by rockyl on 2019-11-05.
 */

import {DisplayObject} from "../../2d/display/index";
import {Node} from "./nodes/Node";

/**
 * 栈式视图容器
 */
export class StackContainer extends Node {
	private _mutex: boolean;
	private _stack = [];

	constructor(mutex = true) {
		super();

		this._mutex = mutex;

		this.percentWidth = 100;
		this.percentHeight = 100;
		this.mouseEnabled = false;
	}

	/**
	 * 推入视图
	 * @param view
	 * @param options
	 * @param dispatch
	 */
	push(view: DisplayObject, options?, dispatch = true) {
		if (this._mutex && this.children.length > 0) {
			this._stack.push(this.removeChildAt(0));
		}
		this.addChild(view);

		if (dispatch) {
			this.dispatchEvent('change', {action: 'push', view, options});
		}
	}

	/**
	 * 替换顶层视图
	 * @param view
	 * @param options
	 */
	replace(view: DisplayObject, options?) {
		if (this.pop(false)) {
			this.push(view, options, false);
			this.dispatchEvent('change', {action: 'replace', view, options});
		}
	}

	/**
	 * 撤出视图
	 */
	pop(dispatch = true) {
		let len = this.children.length;
		if (len <= 0) {
			return false;
		}
		this.removeChildAt(len - 1);
		if (this._mutex) {
			this.addChild(this._stack.pop());
		}
		if (dispatch) {
			this.dispatchEvent('change', {action: 'pop'});
		}
		return true;
	}

	/**
	 * 撤出全部视图
	 * @param view
	 * @param options
	 */
	popAll(view?: DisplayObject, options?) {
		this.removeChildren();
		if (this._mutex) {
			this._stack.splice(0);
		}
		if (view) {
			this.push(view, options, false);
		}
		this.dispatchEvent('change', {action: 'popAll', view, options});
	}
}
