/**
 * Created by rockyl on 2019-11-22.
 */

const template = `
<div class="zeroing-loading-wrapper">
	<div class="zeroing-loading-content">
	</div>
</div>
`;

const style = `
.zeroing-loading-wrapper{
	position: absolute;
	top:0;
	left: 0;
	right: 0;
	bottom: 0;
	display: flex;
	display: -webkit-flex;
	justify-content: center;
	-webkit-justify-content: center;
	align-items: center;
	-webkit-align-items: center;
}
@keyframes part-body
{
	0%,40% {transform: scale(1);}
	20% {transform: scale(1.5);}
}
.zeroing-loading-part {
	transform-origin: 2px 12px;
	position: absolute;
}
.zeroing-loading-part-body{
	background-color: dimgray;
	width: 4px;
	height: 6px;
	border-radius: 2px;
	transform-origin: 2px 6px;
	animation: part-body 1500ms linear infinite;
}
`;

let inited = false;
let wrapper;

function init() {
	if (inited) {
		return;
	}
	inited = true;

	let container = document.createElement('div');
	container.innerHTML = template;
	wrapper = container.removeChild(container.children[0]);

	let styleEl = document.createElement('style');
	styleEl.innerText = style;

	document.body.appendChild(styleEl);

	let content = wrapper.children[0];
	let count = 8;
	let perDelay = 1500 / count;
	let perDeg = 360 / count;
	for (let i = 0; i < count; i++) {
		let part = document.createElement('div');
		part.innerHTML = `<div class="zeroing-loading-part" style="
transform: rotate(${i * perDeg}deg); ">
<div class="zeroing-loading-part-body" style="
animation-delay:${-(count - i) * perDelay}ms;
"></div>
</div>`;
		content.appendChild(part.children[0]);
	}
}

export default {
	onProgress(done, total) {
		init();
		if (!wrapper.parentElement) {
			document.body.appendChild(wrapper);
		}
	},
	onComplete() {
		if (wrapper && wrapper.parentElement) {
			document.body.removeChild(wrapper);
		}
	},
}
