/**
 * Created by rockyl on 2019-11-06.
 *
 * 自适应功能
 */

import {Event} from "../../2d/events/index";

/**
 * 应用自适应
 * @param ctor
 */
export function applyAutoAdjust(ctor: Function) {
	ctor.prototype.applyAutoAdjust = function () {
		let adjustProxy = this.adjustProxy = new AdjustProxy(this);
		this.addEventListener(Event.ADDED_TO_STAGE, adjustProxy.onAddedToStage, adjustProxy);
		this.addEventListener(Event.REMOVED_FROM_STAGE, adjustProxy.onRemovedFromStage, adjustProxy);
	};
	let temp = new AdjustProxy(null);
	for (let key in temp.data)
		Object.defineProperty(ctor.prototype, key, {
			get: function () {
				return this.adjustProxy.data[key];
			},
			set: function (v) {
				const adjustProxy: AdjustProxy = this.adjustProxy;
				if (adjustProxy.data[key] !== v) {
					adjustProxy.data[key] = v;
					adjustProxy.makeDirty();
				}
			},
			enumerable: true,
			configurable: true
		});
}

/**
 * 自适应数据
 */
class AdjustProxy {
	data = {
		percentWidth: NaN,
		percentHeight: NaN,
		left: NaN,
		top: NaN,
		right: NaN,
		bottom: NaN,
		horizonCenter: NaN,
		verticalCenter: NaN,
	};

	private _host;
	private _sizeDirty;

	constructor(host) {
		this._host = host;
		this.makeDirty();
	}

	makeDirty() {
		this._sizeDirty = true;
	}

	onAddedToStage(e) {
		this._host.parent.addEventListener(Event.RESIZE, this.onResize, this);
		this._host.addEventListener(Event.RESIZE, this.onResize, this);
		this._host.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	onRemovedFromStage(e) {
		//this._host.parent.removeEventListener(Event.RESIZE, this.onResize);
		this._host.removeEventListener(Event.RESIZE, this.onResize, this);
		this._host.removeEventListener(Event.ENTER_FRAME, this.onEnterFrame);
	}

	setFrom(adjustProxy: AdjustProxy) {
		for (let k in adjustProxy.data) {
			this.data[k] = adjustProxy.data[k];
		}
	}

	private onResize(e) {
		this._sizeDirty = true;
	}

	private onEnterFrame(e) {
		if (this._sizeDirty) {
			this._sizeDirty = false;

			this.adjustLayout();
		}
	}

	adjustLayout() {
		const that = this._host;

		const {width: pWidth, height: pHeight} = that.parent;
		const {width, height} = that;
		const {percentWidth, percentHeight, left, top, right, bottom, horizonCenter, verticalCenter} = this.data;

		const applyPercentWidth = function () {
			if (t(percentWidth)) {
				that.width = pWidth * percentWidth / 100;
			}
		};
		const applyPercentHeight = function () {
			if (t(percentHeight)) {
				that.height = pHeight * percentHeight / 100;
			}
		};

		let pw = true, ph = true;
		if (t(horizonCenter)) {
			applyPercentWidth();
			that.x = (pWidth - that.width) / 2 + horizonCenter;
		} else {
			if (t(left)) {
				that.x = left;
				if (t(right)) {
					that.width = pWidth - left - right;
					pw = false;
				}
			} else if (t(right)) {
				that.x = pWidth - width - right;
			}
			if (pw) {
				applyPercentWidth();
			}
		}

		if (t(verticalCenter)) {
			applyPercentHeight();
			that.y = (pHeight - that.height) / 2 + verticalCenter;
		} else {
			if (t(top)) {
				that.y = top;
				if (t(bottom)) {
					that.height = pHeight - top - bottom;
					ph = false;
				}
			} else if (t(bottom)) {
				that.y = pHeight - height - bottom;
			}
			if (ph) {
				applyPercentHeight();
			}
		}
	}

}

function t(v) {
	return !isNaN(v) && v !== null && v !== undefined;
}
