/**
 * Created by rockyl on 2019-11-08.
 */

import {VM} from "./VM";
import {getLogSwitch, Logs} from "../log-switch";

const log = getLogSwitch(Logs.PROCESS);

let processMetaLibs = [];
let globalContext = {};
let scriptMap = {};

/**
 * 设置过程库
 * @param metaContexts
 */
export function setProcessMetaLibs(...metaContexts) {
	for (let context of metaContexts) {
		if(context){
			processMetaLibs.push(context);
		}
	}
}

/**
 * 设置去全局上下文
 * @param context
 */
export function setGlobalContext(context) {
	globalContext = context;
	for (let key in context) {
		globalContext[key] = context[key];
	}
}

export function setScriptMap(_scriptMap){
	scriptMap = _scriptMap;
}

/**
 * 执行行为
 * @param sequence
 * @param subEntry
 * @param target
 * @param args
 */
export function executeBehavior(sequence, subEntry = 'main', target, args?) {
	const vm = new VM();
	vm.setup({
		processMetaLibs,
		globalContext,
		target,
		scriptMap,
	});
	vm.executeProcess(sequence, subEntry, null, args)
		.then(result => {
				if(log){
					//console.log(`[${vm.id}] result:`, result);
				}
				return result;
			},
			e => {
				if(log){
					console.log(`[${vm.id}] terminate:`, e);
				}
			}
		);
}
