/**
 * Created by rockyl on 2019-09-10.
 */

import {Process} from "./Process";
import {arrayFind} from "../utils";

let ID_INK = 0;

export class VM {
	_processMetaLibs;
	_globalContext;
	_target;
	_id;
	_scriptMap;

	_pid = 0;

	setup(context) {
		const {processMetaLibs, globalContext, target, scriptMap} = context;

		this._processMetaLibs = processMetaLibs;
		this._globalContext = globalContext;
		this._target = target;
		this._id = ID_INK++;
		this._scriptMap = scriptMap;
	}

	async executeProcess(sequence, id, parentProcess, args) {
		const process = new Process(this._pid++);
		process.init({
			sequence,
			id,
			vm: this,
			parent: parentProcess,
			target: this._target,
		});

		return await process.execute(args);
	}

	getMeta(id) {
		for (let context of this._processMetaLibs) {
			let meta = arrayFind(context, item => item.id === id);
			if (meta) {
				return meta;
			}
		}
	}

	getScript(hash) {
		return this._scriptMap[hash];
	}

	get globalContext() {
		return this._globalContext;
	}

	get id() {
		return this._id;
	}
}
