import {TextField} from "../text/TextField";

/**
 * 文字一个一个出现
 */
export class ShowWord extends TextField {
	/**
	 *
	 * @param text 文本 例子：这里是生命值，闯关失败后\n都会扣除一点生命值
	 * @param deltaTime 文字间隔时间，毫秒计
	 * @param callback 播放完后的回调
	 */
	playWords(text: string, deltaTime: number = 100, callback?: Function) {
		var spiltStrs = text.split("\n");
		//拆分文本
		let strs: string[] = []
		for (var i = 0; i < spiltStrs.length; i++) {
			var spiltStr: string = spiltStrs[i];
			var ori: string = "";
			var index = 0;
			while (index < i) {
				ori += spiltStrs[index];
				ori += "\n";
				index++;
			}
			for (var j = 0; j < spiltStr.length; j++) {
				var str = "" + ori;
				str += spiltStr.substring(0, j + 1)
				strs.push(str)
			}
		}
		// console.log(strs)
		//轮流替换文本
		for (let m = 0; m < strs.length; m++) {
			let str = strs[m];
			setTimeout(() => {
				this.text = str;
				if (m == strs.length - 1) {
					callback && callback();
				}
			}, deltaTime * m)
		}
	}
}