import {ScrollViewBase} from "./ScrollViewBase";
import {DisplayObject} from "../display/DisplayObject";
import {Event} from "../events/Event";
import {SCROLL_DIRECTION} from "../const";
import {dirtyFieldTrigger} from "../../zeroing/decorators";
import Container from "../display/Container";


/**
 * 滚动类的Item基类
 * @class IScrollListItem
 * @public
 * @extends DisplayObject
 * @since 1.0.9
 */
export abstract class ScrollListItemBase extends Container {
	id: number;
	data: any;
	sli_id: number;

	_initData(id: number, data: any) {
		this.id = id;
		this.data = data;

		if(id >= 0){
			this.updateData(data);
		}
	}

	abstract updateData(data: any);
}

/**
 * 滚动列表
 * @class ScrollList
 * @public
 * @extends ScrollViewBase
 * @since 1.0.9
 */
export class ScrollListBase extends ScrollViewBase {
	private _items: Array<ScrollListItemBase> = null;
	private _itemRow: number;
	private _itemCol: number;
	private _itemCount: number;
	private _isInit: number = 0;
	public data: Array<any> = [];
	private downL: DisplayObject = null;
	private _disParam: string;
	private _lastFirstId: number = -1;
	private _updateId: number = -1;

	@dirtyFieldTrigger
	public itemWidth: number = 0;
	@dirtyFieldTrigger
	public itemHeight: number = 0;
	@dirtyFieldTrigger
	public cols: number = 1;
	@dirtyFieldTrigger
	public itemClass: any;

	/**
	 * 获取下拉滚动的loadingView对象
	 * @property loadingView
	 * @since 1.0.9
	 * @return {DisplayObject}
	 */
	public get loadingView(): DisplayObject {
		return this.downL;
	}

	/**
	 * 构造函数
	 * @method ScrollList
	 * @since 1.0.9
	 */
	constructor() {
		super();
		let s = this;
		s._instanceType = "ScrollList";
		s._items = [];
		s._itemCount = 0;
		s.once(Event.ENTER_FRAME, s.onNextFrame, s);
		s.addEventListener(Event.ENTER_FRAME, s.flushData.bind(s));
	}

	protected onNextFrame(event) {
		this.updateViewRect();
	}

	onModify(value, key) {
		switch (key) {
			case 'itemW':

				break;
			case 'itemH':

				break;
			case '_itemCol':

				break;
			case 'itemClass':

				break;
		}
	}

	protected calMaxDistance(): any {
		let key = 'item' + this.paramSize.substr(0, 1).toUpperCase() + this.paramSize.substr(1);
		return this[key] * Math.ceil(this.data.length / this.cols);
	}

	/**
	 * 更新列表数据
	 * @method updateData
	 * @param {Array} data
	 * @param {boolean} isReset 是否重围数据列表。
	 * @since 1.0.9
	 */
	public updateData(data: Array<any>, isReset: boolean = true): void {
		let s: ScrollListBase = this;
		if (!s._isInit || isReset) {
			s.data = data;
		} else {
			s.data = s.data.concat(data);
		}
		s._isInit = 1;
		s._lastFirstId = -1;
		/*s.maxDistance = Math.ceil(s.data.length / s.cols) * s._itemRow;
		if (s.downL) {
			s.downL[s.paramXY] = Math.max(s.distance, s.maxDistance);
			var wh = s.downL.getWH();
			s.maxDistance += (s.paramXY == "x" ? wh.width : wh.height);
		}*/
	}

	private flushData() {
		let s: ScrollListBase = this;
		const items = s._items;
		if(items.length <= 0){
			return;
		}
		if (s._isInit > 0) {
			if (s._updateId != s.viewPort.transform._localID) {
				let id: number = s.viewPort[s.paramXY] > 0 ? 0 : (Math.abs(Math.floor(s.viewPort[s.paramXY] / s._itemRow)) - 1) * s.cols;
				id = id < 0 ? 0 : id;
				if (id != s._lastFirstId) {
					s._lastFirstId = id;
					if (id != items[0].id) {
						for (let r = 0; r < s.cols; r++) {
							if (s.speed > 0) {
								items.unshift(items.pop());
							} else {
								items.push(items.shift());
							}
						}
					}
				}
				for (let i = 0; i < s._itemCount; i++) {
					let item = items[i];
					if (s._isInit == 1) {
						item.sli_id = -1;
					}
					if (item.sli_id != id) {
						if(s.data[id]){
							item._initData(s.data[id] ? id : -1, s.data[id]);
						}
						item[s.paramXY] = Math.floor(id / s.cols) * s._itemRow;
						item[s._disParam] = (id % s.cols) * s._itemCol;
						//如果没有数据则隐藏
						if (s.data[id]) {
							item.sli_id = id;
							item.visible = true;
						} else {
							item.sli_id = -1;
							item.visible = false;
						}
					}
					id++;
				}
				s._isInit = 2;
			}
		}
	}

	/**
	 * 设置可见区域，可见区域的坐标始终在本地坐标中0,0点位置
	 * @method setViewRect
	 * @public
	 * @since 1.1.1
	 */
	public updateViewRect(): void {
		super.updateViewRect();
		let s = this;
		if (s.itemWidth && s.itemHeight) {
			s._updateViewRect();
		}
	}

	protected _updateViewRect() {
		let s: ScrollListBase = this;
		if (s._direction === SCROLL_DIRECTION.VERTICAL) {
			if(s.itemHeight <= 0){
				return;
			}
			s._disParam = "x";
			s._itemRow = s.itemHeight;
			s._itemCol = s.itemWidth;
		} else {
			if(s.itemWidth <= 0){
				return;
			}
			s._disParam = "y";
			s._itemRow = s.itemWidth;
			s._itemCol = s.itemHeight;
		}
		let newCount: number = (Math.ceil(s.distance / s._itemRow) + 1) * s.cols;
		if (newCount != s._itemCount) {
			if (newCount > s._itemCount) {
				for (let i = s._itemCount; i < newCount; i++) {
					let item = s.createItem();
					item.id = -1;
					item.data = null;
					s._items.push(item);
					s.viewPort.addChild(item);
				}
			} else {
				for (let i = 0; i < s._itemCount - newCount; i++) {
					s.viewPort.removeChild(s._items.pop());
				}
			}
			s._itemCount = newCount;
			s._lastFirstId = -1;
		}
	}

	protected createItem() {
		return new this.itemClass();
	}

	/**
	 * 设置加载数据时显示的loading对象
	 * @since 1.0.9
	 * @method setLoading
	 * @param {DisplayObject} downLoading
	 */
	public setLoading(downLoading: DisplayObject): void {
		let s: ScrollListBase = this;
		if (s.downL) {
			s.viewPort.removeChild(s.downL);
			//let wh = s.downL.getWH();
			//s.maxDistance -= (s.paramXY == "x" ? wh.width : wh.height);
			s.downL = null;
		}
		if (downLoading) {
			s.downL = downLoading;
			s.viewPort.addChild(downLoading);
			s.downL[s.paramXY] = Math.max(s.distance, s.maxDistance);
			//let wh = s.downL.getWH();
			//s.maxDistance += (s.paramXY == "x" ? wh.width : wh.height);
		} else {
			s.isStop = false;
		}
	}

	public destroy(): void {
		let s = this;
		s._items = null;
		s.itemClass = null;
		s.data = null;
		s.downL = null;
		super.destroy();
	}
}
