import Texture from "../texture/Texture";
import {Event} from "../events/Event";
import Sprite from "../display/Sprite";

/**
 * 直接通过替换texture替换图片的动画帧
 * 暂时这些动画帧只播放一次，所以简化,要循环时再修改
 * 默认按时间间隔播放
 * 图片都以素材为中心为原点
 */
export class FrameAni extends Sprite {
	texturesAll: Texture[];
	currentFrame: number;
	totalFrames: number;
	isPlay: boolean;

	startTime: number
	/**
	 * 所有时间,播完所用时间
	 */
	allTime: number
	/**
	 * 播放完的回调
	 */
	callback: Function;
	/**
	 * 每秒的帧数，默认30帧
	 */
	_frameRate: number;
	get frameRate() {
		return this._frameRate
	}

	set frameRate(value: number) {
		if (value == this._frameRate) return
		this._frameRate = value;
		this.allTime = this.texturesAll.length / this._frameRate * 1000;
	}

	/**
	 *
	 * @param texturesAll 所有的资源数组
	 */
	constructor(texturesAll: Texture[]) {
		super()
		this.texturesAll = texturesAll;
		this.changeTexture(0);
		this.currentFrame = 0;
		this.totalFrames = texturesAll.length;
		this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this)
		this.frameRate = 30;
	}

	//需要做锁步
	private count = 0;

	onEnterFrame() {
		if (!this.isPlay) {
			// this.count = 0
			return
		}
		// this.count++;
		// if (this.count % 2 == 0) {
		//     this.currentFrame++;
		//     if (this.currentFrame == this.totalFrames/*-1*/) {
		//         this.currentFrame = 0;
		//         this.isPlay = false
		//         this.callback && this.callback();
		//     }
		//     this.texture = RES.getRes(this.sourceAll[this.currentFrame])
		//     this.x = -this.texture.textureWidth / 2;
		//     this.y = -this.texture.textureHeight / 2;
		// }
		var dataNow = Date.now();
		var deltaTime = dataNow - this.startTime;
		var scale = deltaTime / this.allTime;
		if (scale >= 1) {
			this.isPlay = false
			this.callback && this.callback();
		} else {
			this.currentFrame = (scale * this.texturesAll.length) >> 0;
			this.changeTexture(this.currentFrame);
		}
	}

	/**
	 * 从0开始播
	 * 回调是播放完后做回收用的
	 */
	play(callback) {
		this.startTime = Date.now();
		this.isPlay = true;
		this.currentFrame = 0;
		this.changeTexture(0);
		this.callback = callback;
	}

	/**
	 * 重置为0
	 */
	reset() {
		this.isPlay = false;
		this.currentFrame = 0;
		this.changeTexture(0);
	}

	/**
	 * 改texture和居中
	 * @param index
	 */
	private changeTexture(index: number) {
		this.texture = this.texturesAll[index];
		this.x = -this.texture.width / 2;
		this.y = -this.texture.height / 2;
	}
}