import Sprite from "../display/Sprite";
import {MouseEvent} from "../events/MouseEvent";
import Texture from "../texture/Texture";

export class Button extends Sprite {
	textureUp;
	textureDown;
	textureDisable;

	constructor(tUp: Texture, tDown?: Texture, tDisable?: Texture) {
		super(tUp);
		this._instanceType = "Button";

		this.textureUp = tUp;
		this.textureDown = tDown === tUp ? null : tDown;
		this.textureDisable = tDisable || tUp;

		//直接设置纹理的中心点为锚点
		this.anchorX = this.textureUp.width / 2;
		this.anchorY = this.textureUp.height / 2;
		this.initButton();
	}

	/**
	 * @method  _mouseEvent
	 * @param e
	 * @private
	 */
	private _mouseEvent(e: any): void {
		let s = this;
		if (!s._clicked) {
			if (e.type == MouseEvent.MOUSE_DOWN) {
				//如果是点下
				if (s.textureDown) {
					s.texture = s.textureDown
				} else {
					this["frames"] = null
					s.scale.x = s.scale.y = 0.9
				}
			} else {
				if (s.textureDown) {
					s.texture = s.textureUp
				} else {
					this["frames"] = this["framesOri"]
					s.scale.x = s.scale.y = 1
				}
			}
		}
	};

	public initButton(): void {
		let s: any = this;
		s.mouseChildren = false;
		s.addEventListener("onMouseDown", s._mouseEvent, s);
		s.addEventListener("onMouseUp", s._mouseEvent, s);
		s.addEventListener("onMouseOut", s._mouseEvent, s);
		s.texture = s.textureUp
	}

	/**
	 * 设置是否为点击状态
	 * @property clicked
	 * @param {boolean} value
	 * @public
	 * @since 2.0.0
	 * @default false
	 */
	public set clicked(value: boolean) {
		let s = this;
		if (value != s._clicked) {
			if (value) {
				s._mouseEvent({type: "onMouseDown"});
			}
			s._clicked = value;
		}
	}

	public get clicked(): boolean {
		return this._clicked;
	}

	private _clicked = false;

	//设置texture状态textureUp和textureDisable
	set textureStatusEnable(value: boolean) {
		if (value) {
			this.texture = this.textureUp
		} else {
			if (this.textureDisable) {
				this.texture = this.textureDisable;
				this["frames"] = null
			}
		}
	}

	destroy() {
		this.textureUp = null;
		this.textureDown = null;
		this.textureDisable = null;
		super.destroy();
	}
}