import Container from "../display/Container";
import {TEXT_ALIGN} from "../const";
import Texture from "../texture/Texture";
import {BitmapNumber} from "./BitmapNumber";

/**
 * 单位图字缓存
 */
const bitmapNumberPool: BitmapNumber[] = []

/**
 * 位图数字，分数
 * 不管多少位，默认中间数字居中
 * 暂不做通用，以后再说，否则回收问题
 */
export class BitmapNumbers extends Container {
	textures: Texture[]
	/**
	 * 对齐方式
	 */
	align: TEXT_ALIGN = TEXT_ALIGN.CENTER;
	singleWidth: number;
	/**
	 * 数字
	 */
	private _num: number;
	get num(): number {
		return this._num
	}

	/**
	 * 尽量是整数
	 */
	set num(value: number) {
		value = value >> 0
		if (value == this._num) return;
		this._num = value;
		var arr = returnTO(value);
		//位数从小到大add，
		for (var i = 0; i < arr.length; i++) {
			if (this.children[i]) {
				//先用完原先$children里的
				this.children[i]["num"] = arr[i];
			} else {
				//如果没有就
				let o: BitmapNumber = bitmapNumberPool.shift();
				if (!o) {
					o = new BitmapNumber(this.textures);
				} else {
					o.reset(this.textures)
				}
				o.num = arr[i];
				this.addChild(o)
			}
		}
		//如果多了，去掉后面的，回收
		if (this.children.length > arr.length) {
			//移除后序
			for (var i = this.children.length - 1; i >= arr.length; i--) {
				let c = this.children[i];
				this.removeChild(c);
				bitmapNumberPool.push(c);
			}
		}
		//适配
		this.adaptate()
	}

	/**
	 *
	 * @param textures 0到9的贴图
	 */
	constructor(textures: Texture[]) {
		super();
		this.textures = textures;
		this.num = 0;
		this.singleWidth = textures[0].width;
	}

	/**
	 * 适配
	 */
	adaptate() {
		//按顺序排，从右到左，
		var len = this.children.length;
		var w = this.singleWidth;
		var right = len / 2 * w - w;
		if (this.align == TEXT_ALIGN.LEFT) {
			right += len / 2 * w
		} else if (this.align == TEXT_ALIGN.RIGHT) {
			right -= len / 2 * w
		}
		for (var i = 0; i < this.children.length; i++) {
			this.children[i].x = right - w * i;
		}
	}
}

/**
 * 返回个十百等，0是个位
 * 78[ 8, 7]
 * 789[ 9, 8, 7]
 * @param num 整数
 */
function returnTO(num: number) {
	var length = num.toString().length;
	var arr = [];
	var a: any;
	for (var i = 0; i < length; i++) {
		a = (num % Math.pow(10, i + 1)) / Math.pow(10, i);
		arr.push(parseInt(a))
	}
	return arr
}