import Texture from "../texture/Texture";
import Sprite from "../display/Sprite";

/**
 * 位图数字，单个,用与0到9
 */
export class BitmapNumber extends Sprite {
	/**
	 * 图片前缀
	 * 就是那些图片名字
	 * 考虑是否用这个，这样位图数字就需要resName+5形式
	 */
	resName: string
	/**
	 * 0到9的贴图
	 */
	private textures: Texture[];
	/**
	 * 数字0到9
	 */
	private _num: number;
	get num(): number {
		return this._num
	}

	set num(value: number) {
		if (value == this._num) return;
		if (value > 9) {
			this._num = 9;
		} else if (value < 0) {
			this._num = 0;
		}
		this.texture = this.textures[this._num];
	}

	/**
	 *
	 * @param textures 0到9的贴图
	 */
	constructor(textures: Texture[]) {
		super();
		this.textures = textures;
	}

	/**
	 * 替换资源，基本不用吧应该
	 * @param textures
	 */
	reset(textures: Texture[]) {
		this.textures = textures
	}
}