import ObjectRenderer from '../webgl/ObjectRenderer';
import {WebglRenderer} from '../WebglRenderer';

/**
 * 批处理管理器，用于切换渲染插件
 * @class
 */
export default class BatchManager {
	/**
	 *
	 */
	renderer: WebglRenderer;
	/**
	 * 空
	 */
	emptyRenderer: ObjectRenderer;
	/**
	 * 当前使用的ObjectRenderer
	 * @member {ObjectRenderer}
	 */
	currentRenderer: ObjectRenderer;

	constructor(renderer: WebglRenderer) {
		this.renderer = renderer;
		this.emptyRenderer = new ObjectRenderer(renderer);
		this.currentRenderer = this.emptyRenderer;
	}

	/**
	 * Changes the current renderer to the one given in parameter
	 *
	 * @param {ObjectRenderer} objectRenderer - The object renderer to use.
	 */
	setObjectRenderer(objectRenderer: ObjectRenderer) {
		if (this.currentRenderer === objectRenderer) {
			return;
		}

		this.currentRenderer.stop();
		this.currentRenderer = objectRenderer;

		this.currentRenderer.start();
	}

	/**
	 * This should be called if you wish to do some custom rendering
	 * It will basically render anything that may be batched up such as sprites
	 */
	flush() {
		this.setObjectRenderer(this.emptyRenderer);
	}

	/**
	 * Reset the system to an empty renderer
	 */
	reset() {
		this.setObjectRenderer(this.emptyRenderer);
	}
}
