import {Point} from "../math/Point";
import {HashObject} from "../HashObject";

/**
 * 动态可监控ObservablePoint类
 * @class
 */
export class ObservablePoint extends HashObject {
	_x: number;
	_y: number;
	cb: any;
	scope: any;

	/**
	 * @param {Function} cb - 值改变时的回调
	 * @param {object} scope - 回调里的上下文this
	 * @param {number} [x=0] - x
	 * @param {number} [y=0] - y
	 */
	constructor(cb: Function, scope: any, x: number = 0, y: number = 0) {
		super();
		let s = this;
		s._instanceType = "ObservablePoint";
		this._x = x;
		this._y = y;

		this.cb = cb;
		this.scope = scope;
	}

	/**
	 * 设置xy
	 * @param {number} [x=0]
	 * @param {number} [y=0]
	 */
	set(x: number = 0, y: number = 0) {
		const _x = x || 0;
		const _y = y || ((y !== 0) ? _x : 0);

		if (this._x !== _x || this._y !== _y) {
			this._x = _x;
			this._y = _y;
			this.cb.call(this.scope);
		}
	}

	/**
	 * 从一个点复制xy
	 *
	 * @param {Point|ObservablePoint} point
	 */
	copy(point: Point | ObservablePoint) {
		if (this._x !== point.x || this._y !== point.y) {
			this._x = point.x;
			this._y = point.y;
			this.cb.call(this.scope);
		}
	}

	get x() {
		return this._x;
	}

	set x(value) {
		if (this._x !== value) {
			this._x = value;
			this.cb.call(this.scope);
		}
	}

	get y() {
		return this._y;
	}

	set y(value) {
		if (this._y !== value) {
			this._y = value;
			this.cb.call(this.scope);
		}
	}

	destroy() {

	}
}
