import FillStyle from './FillStyle';
import {LINE_ALIGNMENT} from '../../const';

/**
 * 图形的画线模式
 */
export default class LineStyle extends FillStyle {

	/**
	 * webgl的画线模式
	 * 默认false
	 */
	native: boolean;
	/**
	 * 线宽度
	 * 默认0
	 */
	width: number;
	/**
	 * 线的对齐方式
	 * 默认LINE_ALIGNMENT.middle  0.5
	 */
	alignment: LINE_ALIGNMENT;

	/**
	 * Clones the object
	 *
	 * @return {LineStyle}
	 */
	clone(): LineStyle {
		const obj: LineStyle = new LineStyle();
		obj.color = this.color;
		obj.alpha = this.alpha;
		obj.texture = this.texture;
		obj.matrix = this.matrix;
		obj.visible = this.visible;
		obj.width = this.width;
		obj.alignment = this.alignment;
		obj.native = this.native;
		return obj;
	}

	/**
	 * 重置
	 */
	reset() {
		super.reset();
		// 默认黑色0x000000
		this.color = 0x0;
		this.width = 0;
		this.alignment = 0.5;
		this.native = false;
	}
}
