import Circle from "./shapes/Circle";
import {Matrix, Rectangle} from "../math";
import Ellipse from "./shapes/Ellipse";
import Polygon from "./shapes/Polygon";
import RoundedRectangle from "./shapes/RoundedRectangle";
import {HashObject} from "../HashObject";
import LineStyle from "./styles/LineStyle";
import FillStyle from "./styles/FillStyle";

/**
 * A GraphicsData object.
 * 记录图形数据
 */
export default class GraphicsData extends HashObject {

	fillStyle: FillStyle;
	lineStyle: LineStyle;
	matrix: Matrix;
	holes: any[];
	/**
	 * The shape object to draw.
	 * @member {Circle|Ellipse|Polygon|Rectangle|RoundedRectangle}
	 */
	shape: any;
	/**
	 * The type of the shape, see the Const.Shapes file for all the existing types,
	 * @member {number}
	 */
	type: number;
	/**
	 * 点的一维数组[x,y,x1,y1,x2,y2]
	 * 存下shape的点数据，因为如果shape不是poly不会特意存下points
	 */
	points: number[]

	/**
	 *
	 */
	constructor(
		shape: Circle | Rectangle | Ellipse | Polygon | RoundedRectangle,
		fillStyle: FillStyle = null,
		lineStyle: LineStyle = null,
		matrix: Matrix = null
	) {
		super();
		this._instanceType = "GraphicsData"

		this.shape = shape;
		this.lineStyle = lineStyle;
		this.fillStyle = fillStyle;
		this.matrix = matrix;

		this.holes = [];
		this.type = shape.type;
		this.points = [];
	}

	/**
	 * Creates a new GraphicsData object with the same values as this one.
	 *
	 * @return {GraphicsData} Cloned GraphicsData object
	 */
	clone(): GraphicsData {
		return new GraphicsData(
			this.shape,
			this.fillStyle,
			this.lineStyle,
			this.matrix
		);
	}

	/**
	 * Destroys the Graphics data.
	 */
	destroy() {
		this.shape = null;
		this.holes.length = 0;
		this.holes = null;
		this.points.length = 0;
		this.points = null;
		this.lineStyle = null;
		this.fillStyle = null;
	}
}
