import {HashObject} from "../HashObject";

/**
 * 事件类,引擎中一切事件的基类
 * @class Event
 * @extends AObject
 * @public
 * @since 1.0.0
 */
export class Event extends HashObject {

	// public static IMAGE_LOADED: string = "onImageLoaded"

	/**
	 * 舞台尺寸发生变化时触发
	 * @Event
	 * @property RESIZE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static RESIZE: string = "onResize";

	/**
	 * ScrollPage组件滑动到开始位置事件
	 * @property ON_SCROLL_TO_HEAD
	 * @static
	 * @since 1.1.0
	 * @type {string}
	 */
	public static ON_SCROLL_TO_HEAD: string = "onScrollToHead";
	/**
	 * ScrollPage组件停止滑动事件
	 * @property ON_SCROLL_STOP
	 * @static
	 * @since 1.1.0
	 * @type {string}
	 */
	public static ON_SCROLL_STOP: string = "onScrollStop";
	/**
	 * ScrollPage组件开始滑动事件
	 * @property ON_SCROLL_START
	 * @static
	 * @since 1.1.0
	 * @type {string}
	 */
	public static ON_SCROLL_START: string = "onScrollStart";
	/**
	 * ScrollPage组件滑动到结束位置事件
	 * @property ON_SCROLL_TO_END
	 * @static
	 * @since 1.1.0
	 * @type {string}
	 */
	public static ON_SCROLL_TO_END: string = "onScrollToEnd";
	/**
	 * 舞台初始化完成后会触发的事件
	 * @property ON_INIT_STAGE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static ON_INIT_STAGE: string = "onInitStage";
	/**
	 * 显示对象加入到舞台事件
	 * @Event
	 * @property ADD_TO_STAGE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static ADDED_TO_STAGE: string = "onAddedToStage";
	/**
	 * 显示对象从舞台移出事件
	 * @Event
	 * @property REMOVE_TO_STAGE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static REMOVED_FROM_STAGE: string = "onRemovedFromStage";
	/**
	 * 显示对象 循环帧事件
	 * @Event
	 * @property ENTER_FRAME
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static ENTER_FRAME: string = "onEnterFrame";
	/**
	 * MovieClip 播放完成事件
	 * @Event
	 * @property END_FRAME
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static END_FRAME: string = "onEndFrame";
	/**
	 * MovieClip 帧标签事件
	 * @Event
	 * @property CALL_FRAME
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static CALL_FRAME: string = "onCallFrame";
	/**
	 * 可见事件
	 * @Event
	 * @property VISIBLE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static VISIBLE: string = "visible";
	/**
	 * 隐藏事件
	 * @Event
	 * @property HIDDEN
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static HIDDEN: string = "hidden";
	/**
	 * 完成事件
	 * @Event
	 * @property COMPLETE
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static COMPLETE: string = "onComplete";
	/**
	 * 加载过程事件
	 * @Event
	 * @property PROGRESS
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static PROGRESS: string = "onProgress";
	/**
	 * 获取焦点
	 * @Event
	 * @property FOCUS
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static FOCUS: string = "focus";
	/**
	 * 失去焦点
	 * @Event
	 * @property BLUR
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static BLUR: string = "blur";
	/**
	 * 内容变化时触发
	 * @Event
	 * @property BLUR
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static CHANGING: string = "changing";
	/**
	 * 出错事件
	 * @Event
	 * @property ERROR
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static ERROR: string = "onError";
	/**
	 * 中断事件
	 * @Event
	 * @property ABORT
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static ABORT: string = "onAbort";
	/**
	 * 开始事件
	 * @Event
	 * @property START
	 * @type {string}
	 * @static
	 * @public
	 * @since 1.0.0
	 */
	public static START: string = "onStart";
	/**
	 * 定时器触发事件
	 * @property TIMER
	 * @static
	 * @since 1.0.9
	 * @public
	 * @type {string}
	 */
	public static TIMER: string = "onTimer";
	/**
	 * 定时器完成事件
	 * @property TIMER_COMPLETE
	 * @since 1.0.9
	 * @static
	 * @public
	 * @type {string}
	 */
	public static TIMER_COMPLETE: string = "onTimerComplete";
	/**
	 * 布局失效事件
	 * @property LAYOUT_INVALID
	 * @since 1.0.0
	 * @static
	 * @public
	 * @type {string}
	 */
	public static LAYOUT_INVALID: string = "LAYOUT_INVALID";
	/**
	 * 数据更新事件
	 * @property UPDATE_DATA
	 * @since 1.0.0
	 * @static
	 * @public
	 * @type {string}
	 */
	public static UPDATE_DATA: string = "UPDATE_DATA";
	/**
	 * 事件类型名
	 * @property type
	 * @type {string}
	 * @public
	 * @since 1.0.0
	 */
	public type: string = "";
	/**
	 * 触发此事件的对象
	 * @property target
	 * @public
	 * @since 1.0.0
	 * @type {any}
	 */
	public target: any = null;
	/**
	 * 随着事件一起附带的信息对象
	 * 所有需要随事件一起发送的信息都可以放在此对象中
	 * @property data
	 * @public
	 * @since 1.0.0
	 * @type {any}
	 * @default null
	 */
	public data: any = null;

	/**
	 * @method Event
	 * @param {string} type 事件类型
	 * @public
	 * @since 1.0.0
	 */
	public constructor(type: string) {
		super();
		this._instanceType = "Event";
		this.type = type;
	}

	/**
	 * 防止对事件流中当前节点中和所有后续节点中的事件侦听器进行处理。
	 * @method stopImmediatePropagation
	 * @public
	 * @return {void}
	 * @since 2.0.0
	 */
	public stopImmediatePropagation(): void {
		this._pd = true;
	}

	/**
	 * 防止对事件流中当前节点的后续节点中的所有事件侦听器进行处理。
	 * @method stopPropagation
	 * @public
	 * @since 2.0.0
	 * @return {void}
	 */
	public stopPropagation(): void {
		this._bpd = true;
	}

	private _bpd: boolean = false;
	/**
	 * 是否阻止事件向下冒泡
	 * @property _pd
	 * @type {boolean}
	 * @private
	 * @since 1.0.0
	 */
	private _pd: boolean = false;

	public destroy(): void {
		let s = this;
		s.target = null;
		s.data = null;
	}

	/**
	 * 重围事件到初始状态方便重复利用
	 * @method reset
	 * @param {string} type
	 * @param target
	 * @since 2.0.0
	 * @return {void}
	 * @public
	 */
	public reset(type: string, target: any): void {
		let s = this;
		s.target = target;
		s._pd = false;
		s._bpd = false;
		s.type = type;
		delete s.data;
	}
}
