//这里都是一些常量
/**
 * 版本号
 * @static
 * @constant
 * @name VERSION
 * @type {string}
 */
export const VERSION = "1.0";

/**
 * 屏幕分辨率，尽量最大为2，否则画布太大影响性能
 */
export const devicePixelRatio: number = window.devicePixelRatio ? window.devicePixelRatio : 1;

/**
 * 一个 StageScaleMode 中指定要使用哪种缩放模式的值。以下是有效值：
 * StageScaleMode.EXACT_FIT -- 整个应用程序在指定区域中可见，但不尝试保持原始高宽比。可能会发生扭曲，应用程序可能会拉伸或压缩显示。
 * StageScaleMode.SHOW_ALL -- 整个应用程序在指定区域中可见，且不发生扭曲，同时保持应用程序的原始高宽比。应用程序的两侧可能会显示边框。
 * StageScaleMode.NO_BORDER -- 整个应用程序填满指定区域，不发生扭曲，但有可能进行一些裁切，同时保持应用程序的原始高宽比。
 * StageScaleMode.NO_SCALE -- 整个应用程序的大小固定，因此，即使播放器窗口的大小更改，它也会保持不变。如果播放器窗口比内容小，则可能进行一些裁切。
 * StageScaleMode.FIXED_WIDTH -- 整个应用程序的宽固定，因此，即使播放器窗口的大小更改，它也会保持不变。如果播放器窗口比内容小，则可能进行一些裁切。
 * StageScaleMode.FIXED_HEIGHT -- 整个应用程序的高固定，因此，即使播放器窗口的大小更改，它也会保持不变。如果播放器窗口比内容小，则可能进行一些裁切。
 * @property StageScaleMode
 * @type {Object}
 * @public
 * @since 1.0.0
 * @static
 * @example
 *      //动态更改stage的对齐方式示例
 *      //以下代码放到一个舞台的显示对象的构造函数中
 *      let s=this;
 *      s.addEventListener(Event.ADD_TO_STAGE,function(e){
 *          let i=0;
 *          s.stage.addEventListener(MouseEvent.CLICK,function(e){
 *              let aList=[StageScaleMode.EXACT_FIT,StageScaleMode.NO_BORDER,StageScaleMode.NO_SCALE,StageScaleMode.SHOW_ALL,StageScaleMode.FIXED_WIDTH,StageScaleMode.FIXED_HEIGHT]
 *              let state=e.currentTarget;
 *              state.scaleMode=aList[i];
 *              state.resize();
 *              if(i>5){i=0;}
 *          }
 *      }
 *
 */
export let StageScaleMode: { EXACT_FIT: string, NO_BORDER: string, NO_SCALE: string, SHOW_ALL: string, FIXED_WIDTH: string, FIXED_HEIGHT: string } = {
	EXACT_FIT: "exactFit",
	NO_BORDER: "noBorder",
	NO_SCALE: "noScale",
	SHOW_ALL: "showAll",
	FIXED_WIDTH: "fixedWidth",
	FIXED_HEIGHT: "fixedHeight"
};
/**
 * 获取设备号
 */
export const osType: string = (function () {
	let n = navigator.userAgent.toLocaleLowerCase();
	let reg1 = /android/;
	let reg2 = /iphone|ipod|ipad/;
	if (reg1.test(n)) {
		return "android";
	} else if (reg2.test(n)) {
		return "ios"
	} else {
		return "pc";
	}
})();
console.log(devicePixelRatio, osType)


let PI: number = Math.PI;
let HalfPI: number = PI >> 1;
let PacPI: number = PI + HalfPI;

/**
 * @method cos
 * @private
 * @param {number} angle,弧度制
 * @return {number}
 */
export function cos(angle: number): number {
	switch (angle) {
		case HalfPI:
		case -PacPI:
			return 0;
		case PI:
		case -PI:
			return -1;
		case PacPI:
		case -HalfPI:
			return 0;
		default:
			return Math.cos(angle);
	}
}

/**
 * @method sin
 * @param {number} angle,弧度制
 * @return {number}
 */
export function sin(angle: number): number {
	switch (angle) {
		case HalfPI:
		case -PacPI:
			return 1;
		case PI:
		case -PI:
			return 0;
		case PacPI:
		case -HalfPI:
			return -1;
		default:
			return Math.sin(angle);
	}
}

/**
 * Two Pi.
 *
 * @static
 * @constant
 * @type {number}
 */
export const PI_2: number = PI * 2;

/**
 * Conversion factor for converting radians to degrees.
 * 弧度转角度
 * @static
 * @constant
 * @type {number}
 */
export const RAD_TO_DEG: number = 180 / PI;

/**
 * Conversion factor for converting degrees to radians.
 * 角度转弧度
 * @static
 * @constant
 * @type {number}
 */
export const DEG_TO_RAD: number = PI / 180;

/**
 * 渲染方式记录
 * @static
 * @constant
 * @name RENDERER_TYPE
 * @type {object}
 * @property {number} UNKNOWN - Unknown render type.
 * @property {number} WEBGL - WebGL render type.
 * @property {number} CANVAS - Canvas render type.
 */
export enum RENDERER_TYPE {
	UNKNOWN = 'unknown',
	WEBGL = 'webgl',
	CANVAS = 'canvas',
};

/**
 * 各种形状
 * @static
 * @constant
 * @name SHAPES
 * @type {object}
 * @property {number} POLY Polygon  多边形
 * @property {number} RECT Rectangle 矩形
 * @property {number} CIRC Circle 圆形
 * @property {number} ELIP Ellipse 椭圆
 * @property {number} RREC Rounded Rectangle 圆角矩形
 */
export enum SHAPES {
	POLY = 0,
	RECT,
	CIRC,
	ELIP,
	RREC,
};

/**
 * 着色器浮点精度
 * @static
 * @constant
 * @name PRECISION
 * @type {object}
 * @property {string} LOW='lowp'
 * @property {string} MEDIUM='mediump'
 * @property {string} HIGH='highp'
 */
export enum PRECISION {
	LOW = 'lowp',
	MEDIUM = 'mediump',
	HIGH = 'highp',
};

/**
 * 文本渐变方式，以后用
 * @static
 * @constant
 * @name TEXT_GRADIENT
 * @type {object}
 * @property {number} LINEAR_VERTICAL 水平渐变
 * @property {number} LINEAR_HORIZONTAL 垂直渐变
 */
export enum TEXT_GRADIENT {
	LINEAR_VERTICAL = 0,
	LINEAR_HORIZONTAL,
};

/**
 * 文本对齐方式  水平
 */
export enum TEXT_ALIGN {
	CENTER = "center",
	LEFT = "left",
	RIGHT = "right",
}

export enum VERTICAL_ALIGN {
	MIDDLE = "middle",
	UP = "up",
	DOWN = "down",
}

/**
 * 文本类型，单行或多行
 */
export enum TEXT_lINETYPE {
	SINGLE = "single",
	MULTI = "multi"
}

/**
 * 画线时的对齐方式
 */
export enum LINE_ALIGNMENT {
	middle = 0.5,
	outter = 1,
	inner = 0
}

/**
 * canvas线头
 */
export enum LINE_CAP {
	BUTT = "butt",
	ROUND = "round",
	SQUARE = "square",
}

/**
 * canvas线连接处
 */
export enum LINE_JOIN {
	MITER = "miter",
	ROUND = "round",
	BEVEL = "bevel"
}


/**
 * Various blend modes supported by
 *
 * IMPORTANT - The WebGL renderer only supports the NORMAL, ADD, MULTIPLY and SCREEN blend modes.
 * Anything else will silently act like NORMAL.
 *
 * @static
 * @constant
 * @name BLEND_MODES
 * @type {object}
 * @property {number} NORMAL
 * @property {number} ADD
 * @property {number} MULTIPLY
 * @property {number} SCREEN
 * @property {number} OVERLAY
 * @property {number} DARKEN
 * @property {number} LIGHTEN
 * @property {number} COLOR_DODGE
 * @property {number} COLOR_BURN
 * @property {number} HARD_LIGHT
 * @property {number} SOFT_LIGHT
 * @property {number} DIFFERENCE
 * @property {number} EXCLUSION
 * @property {number} HUE
 * @property {number} SATURATION
 * @property {number} COLOR
 * @property {number} LUMINOSITY
 */
export enum BLEND_MODES {
	NORMAL = 0,
	ADD,
	MULTIPLY,
	SCREEN,
	OVERLAY,
	DARKEN,
	LIGHTEN,
	COLOR_DODGE,
	COLOR_BURN,
	HARD_LIGHT,
	SOFT_LIGHT,
	DIFFERENCE,
	EXCLUSION,
	HUE,
	SATURATION,
	COLOR,
	LUMINOSITY,
	NORMAL_NPM,
	ADD_NPM,
	SCREEN_NPM,
};

/**
 * Various webgl draw modes. These can be used to specify which GL drawMode to use
 * under certain situations and renderers.
 *
 * @static
 * @constant
 * @name DRAW_MODES
 * @type {object}
 * @property {number} POINTS
 * @property {number} LINES
 * @property {number} LINE_LOOP
 * @property {number} LINE_STRIP
 * @property {number} TRIANGLES
 * @property {number} TRIANGLE_STRIP
 * @property {number} TRIANGLE_FAN
 */
export enum DRAW_MODES {
	POINTS = 0,
	LINES,
	LINE_LOOP,
	LINE_STRIP,
	TRIANGLES,
	TRIANGLE_STRIP,
	TRIANGLE_FAN,
};

/**
 * The scale modes that are supported by
 *
 * The {@link settings.SCALE_MODE} scale mode affects the default scaling mode of future operations.
 * It can be re-assigned to either LINEAR or NEAREST, depending upon suitability.
 *
 * @static
 * @constant
 * @name SCALE_MODES
 * @type {object}
 * @property {number} LINEAR Smooth scaling
 * @property {number} NEAREST Pixelating scaling
 */
export enum SCALE_MODES {
	LINEAR = 0,
	NEAREST,
};

/**
 * The wrap modes that are supported by
 *
 * The {@link settings.WRAP_MODE} wrap mode affects the default wrapping mode of future operations.
 * It can be re-assigned to either CLAMP or REPEAT, depending upon suitability.
 * If the texture is non power of two then clamp will be used regardless as webGL can
 * only use REPEAT if the texture is po2.
 *
 * This property only affects WebGL.
 *
 * @static
 * @constant
 * @name WRAP_MODES
 * @type {object}
 * @property {number} CLAMP - The textures uvs are clamped
 * @property {number} REPEAT - The texture uvs tile and repeat
 * @property {number} MIRRORED_REPEAT - The texture uvs tile and repeat with mirroring
 */
export enum WRAP_MODES {
	CLAMP = 33071,
	REPEAT = 10497,
	MIRRORED_REPEAT = 33648,
};

/**
 * The gc modes that are supported by
 *
 * The {@link settings.GC_MODE} Garbage Collection mode for textures is AUTO
 * If set to GC_MODE, the renderer will occasionally check textures usage. If they are not
 * used for a specified period of time they will be removed from the GPU. They will of course
 * be uploaded again when they are required. This is a silent behind the scenes process that
 * should ensure that the GPU does not  get filled up.
 *
 * Handy for mobile devices!
 * This property only affects WebGL.
 *
 * @static
 * @constant
 * @name GC_MODES
 * @type {object}
 * @property {number} AUTO - Garbage collection will happen periodically automatically
 * @property {number} MANUAL - Garbage collection will need to be called manually
 */
export enum GC_MODES {
	AUTO = 0,
	MANUAL,
};

/**
 * Regexp for image type by extension.
 *
 * @static
 * @constant
 * @type {RegExp|string}
 * @example `image.png`
 */
export const URL_FILE_EXTENSION: any = /\.(\w{3,4})(?:$|\?|#)/i;

/**
 * Regexp for data URI.
 * Based on: {@link https://github.com/ragingwind/data-uri-regex}
 *
 * @static
 * @constant
 * @name DATA_URI
 * @example data:image/png;base64
 */
export const DATA_URI: any = /^\s*data:(?:([\w-]+)\/([\w+.-]+))?(?:;charset=([\w-]+))?(?:;(base64))?,(.*)/i;

export enum SCROLL_DIRECTION {
	HORIZONTAL = 'horizontal',
	VERTICAL = 'vertical',
}
