/**
 * Created by rockyl on 2019-11-07.
 */

declare const engine: any;

export default class TouchZoom {
	static id = 'touch-zoom';

	host;
	zoomTo = 1.1;

	mounted() {
		this.host.anchorX = this.host.width / 2;
		this.host.anchorY = this.host.height / 2;

		this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this._onMouseDown, this);
		this.host.addEventListener(engine.MouseEvent.MOUSE_UP, this._onMouseUp, this);
	}

	private _onMouseDown(e) {
		this.host.scaleX = this.host.scaleY = this.zoomTo;
	}

	private _onMouseUp(e) {
		this.host.scaleX = this.host.scaleY = 1;
	}
}
