"use strict";
exports.__esModule = true;
var TouchZoom = (function () {
    function TouchZoom() {
        this.zoomTo = 1.1;
    }
    TouchZoom.prototype.mounted = function () {
        this.host.anchorX = this.host.width / 2;
        this.host.anchorY = this.host.height / 2;
        this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this._onMouseDown, this);
        this.host.addEventListener(engine.MouseEvent.MOUSE_UP, this._onMouseUp, this);
    };
    TouchZoom.prototype._onMouseDown = function (e) {
        this.host.scaleX = this.host.scaleY = this.zoomTo;
    };
    TouchZoom.prototype._onMouseUp = function (e) {
        this.host.scaleX = this.host.scaleY = 1;
    };
    TouchZoom.id = 'touch-zoom';
    return TouchZoom;
}());
exports["default"] = TouchZoom;
