/**
 * Created by rockyl on 2019-09-29.
 */

export default class Process {
	constructor(parent, data, resolveProcess) {
		this._resolveProcess = resolveProcess;
		this._parent = parent;
		this._data = data;
		if (typeof data.meta === 'string') {
			this.metaID = data.meta;
		} else {
			this.meta = data.meta;
		}
	}

	get data() {
		return this._data;
	}

	get parent() {
		return this._parent;
	}

	get uuid() {
		return this._data.uuid;
	}

	set metaID(id) {
		this._data.meta = id;
		this.meta = this.resolveMeta(id);
	}

	resolveMeta(id) {
		let meta = this.meta && this.meta.metas ? this.meta.metas.find(meta => meta.id === id) : null;
		if (!meta && this._parent) {
			meta = this._parent.resolveMeta(id);
		}
		if (!meta) {
			meta = this._resolveProcess(id);
		}

		return meta;
	}
}
