const serverHost = 'http://10.10.95.74:7777';

const MonacoWebpackPlugin = require('monaco-editor-webpack-plugin');

module.exports = {
  publicPath: process.env.NODE_ENV === 'production' ? '//yun.duiba.com.cn/editor/zeroing/v1/' : '',
  pluginOptions: {
    i18n: {
      locale: 'en',
      fallbackLocale: 'en',
      localeDir: 'locales',
      enableInSFC: true
    }
  },
  devServer: {
    host: '0.0.0.0',
    port: '8080',
    proxy: {
      '/sso': {
        target: serverHost,
      },
      '/api': {
        target: serverHost,
      },
      'polaris': {
        target: serverHost
      }
    }
  },
  configureWebpack: {
    plugins: [
      new MonacoWebpackPlugin({
        languages: ['javascript', 'typescript', 'json', 'html'],
        publicPath: process.env.NODE_ENV === 'production' ? "/monaco" : "",
      })
    ]
  }
};
