// 属性

export default {
	node: {
		alias: '基础',
		props: {
			visible: {
				alias: '是否可见',
				type: 'boolean',
				default: true
			},
			x: {
				alias: 'x坐标',
				type: 'number',
				default: 0,
			},
			y: {
				alias: 'y坐标',
				type: 'number',
				default: 0,
			},
			width: {
				alias: '宽度',
				type: 'number',
			},
			height: {
				alias: '高度',
				type: 'number',
			},
			left: {
				alias: '左边距',
				type: 'number',
			},
			right: {
				alias: '右边距',
				type: 'number',
			},
			top: {
				alias: '上边距',
				type: 'number',
			},
			bottom: {
				alias: '下边距',
				type: 'number',
			},
			horizonCenter: {
				alias: '水平居中偏移',
				type: 'number',
			},
			verticalCenter: {
				alias: '垂直居中偏移',
				type: 'number',
			},
			rotation: {
				alias: '旋转',
				type: 'number',
				default: 0
			},
			anchorX: {
				alias: '锚点X',
				type: 'number',
				default: 0
			},
			anchorY: {
				alias: '锚点Y',
				type: 'number',
				default: 0
			},
			scaleX: {
				alias: 'X轴缩放',
				type: 'number',
				default: 1,
			},
			scaleY: {
				alias: 'Y轴缩放',
				type: 'number',
				default: 1,
			},
			alpha: {
				alias: '透明度',
				type: 'number',
				default: 1,
			},
			mouseEnabled: {
				alias: '可否交互',
				type: 'boolean',
				default: true
			},
			mouseChildren: {
				alias: '子集交互',
				type: 'boolean',
				default: true
			},
		}
	},
	label: {
		base: 'node',
		alias: '文本',
		props: {
			text: {
				alias: '文本内容',
				type: 'string',
				default: ''
			},
			textFlow: {
				alias: '文本流',
				type: 'object',
			},
			font: {
				alias: '字体',
				type: 'string',
				default: 'Arial'
			},
			htmlText: {
				alias: 'HTML内容',
				type: 'string',
				default: '',
			},
			bold: {
				alias: '粗体',
				type: 'boolean',
				default: false,
			},
			italic: {
				alias: '斜体',
				type: 'boolean',
				default: false,
			},
			fillColor: {
				alias: '颜色',
				type: 'color',
				default: '#000'
			},
			stroke: {
				alias: '描边宽度',
				type: 'number',
				default: 0,
			},
			strokeColor: {
				alias: '描边颜色',
				type: 'color',
				default: '#ffffff'
			},
			lineType: {
				alias: '自动换行',
				type: 'enum',
				enum: [
					{label: '单行', value: 'single'},
					{label: '多行', value: 'multi'},
				],
				default: 'single'
			},
			size: {
				alias: '字体大小',
				type: 'number',
				default: 12
			},
			lineSpacing: {
				alias: '行间距',
				type: 'number',
				default: 0
			},
			textAlign: {
				alias: '文本对齐',
				type: 'enum',
				enum: [
					{label: '靠左', value: 'left'},
					{label: '居中', value: 'center'},
					{label: '靠右', value: 'right'}
				],
				default: 'left'
			},
			verticalAlign: {
				alias: '纵向对齐',
				type: 'enum',
				enum: [
					{label: '靠上', value: 'up'},
					{label: '居中', value: 'middle'},
					{label: '靠下', value: 'down'}
				],
				default: 'up'
			},
		}
	},
	bitmapText: {
		base: 'node',
		alias: '图片文本',
		props: {
			text: {
				alias: '文本内容',
				type: 'string',
				default: '',
			},
			font: {
				alias: '字体名',
				type: 'string',
				default: '',
			},
			letterSpacing: {
				alias: '字间距',
				type: 'number',
				default: 0
			},
			verticalAlign: {
				alias: '纵向对齐',
				type: 'enum',
				enum: [
					{label: '靠上', value: 'up'},
					{label: '居中', value: 'middle'},
					{label: '靠下', value: 'down'}
				],
				default: 'down'
			},
		}
	},
	textinput: {
		base: 'label',
		alias: '输入框',
		props: {
			type: {
				alias: '输入类型',
				type: 'enum',
				enum: [
					{label: '文本', value: 'text'},
					{label: '密码', value: 'password'},
				],
				default: 'text'
			},
			charRegStr: {
				alias: '字符正则式',
				type: 'string',
				default: '',
			},
			maxLength: {
				alias: '最大长度',
				type: 'number',
			},
			placeholder: {
				alias: '提示文字',
				type: 'string',
				default: '',
			},
			placeholderColor: {
				alias: '提示颜色',
				type: 'color',
				default: '#666666'
			},
		}
	},
	image: {
		base: 'node',
		alias: '图片',
		props: {
			source: {
				alias: '来源',
				type: 'source',
				default: ''
			},
			imageWidth: {
				alias: '原图宽度',
				type: 'text',
				default: '',
				desc: '原图片的宽度',
			},
			imageHeight: {
				alias: '原图高度',
				type: 'text',
				default: '',
				desc: '原图片的高度',
			}
		}
	},
	svga: {
		base: 'node',
		alias: 'SVGA',
		props: {
			source: {
				alias: '来源',
				type: 'source',
				default: ''
			},
			lockStep: {
				alias: '锁步',
				type: 'boolean',
				default: false
			},
			autoPlay: {
				alias: '自动播放',
				type: 'boolean',
				default: false
			},
		}
	},
	shape: {
		base: 'node',
		alias: '形状',
		props: {
			fillColor: {
				alias: '填充色',
				type: 'color',
				default: '#fff'
			},
			strokeColor: {
				alias: '边框颜色',
				type: 'color',
				default: '#000'
			},
			strokeWidth: {
				alias: '边框宽度',
				type: 'number',
				default: 0,
			},
		}
	},
	rect: {
		base: 'shape',
		alias: '矩形',
		props: {
			borderRadius: {
				alias: '圆角',
				type: 'number',
				default: 0,
			}
		}
	},
	circle: {
		base: 'shape',
		alias: '圆形',
		props: {}
	},
	scrollView: {
		base: 'node',
		alias: '滚动视图',
		props: {
			direction: {
				alias: '滚动方向',
				type: 'enum',
				enum: [
					{label: '纵向', value: 'vertical'},
					{label: '横向', value: 'horizontal'}
				],
				default: 'vertical',
			},
			isSpringBack: {
				alias: '回弹效果',
				type: 'boolean',
				default: true,
			},
			maxSpeed: {
				alias: '最大速度',
				type: 'number',
				default: 100,
			},
			fSpeed: {
				alias: '摩擦力',
				type: 'number',
				default: 20,
			},
		}
	},
	scrollList: {
		base: 'scrollView',
		alias: '滚动列表',
		props: {
			itemWidth: {
				alias: '单项宽度',
				type: 'number',
				default: 0,
			},
			itemHeight: {
				alias: '单项高度',
				type: 'number',
				default: 0,
			},
			cols: {
				alias: '行列数',
				type: 'number',
				default: 1,
			},
			cloneEvents: {
				alias: '克隆事件',
				type: 'boolean',
				props: {
					width: 40,
				},
				default: true,
			},
			cloneScripts: {
				alias: '克隆脚本',
				type: 'boolean',
				props: {
					width: 40,
				},
				default: true,
			},
		}
	},
	htmlView: {
		base: 'node',
		alias: 'HTML视图',
		props: {
			htmlElement: {
				alias: 'HTML内容',
				type: 'string',
			},
		}
	},
}
