/**
 * Created by rockyl on 2019-09-18.
 */

import Vue from 'vue'
import Vuex from 'vuex'
import {editorStore} from "./modules/editor";
import {projectsStore} from "./modules/projects";
import {projectStore} from "./modules/project";
import SaveToLocalPlugin from "./save-to-local-plugin";
import {behaviorStore} from "./modules/behavior";

Vue.use(Vuex);

export default new Vuex.Store({
	state: {},
	mutations: {

	},
	actions: {

	},
	modules: {
		editor: editorStore,
		projects: projectsStore,
		project: projectStore,
		behavior: behaviorStore,
	},
	plugins: [
		SaveToLocalPlugin({
			mutationTypes: [
				'makeProjectDirty',
				'modifyProject',
				'addNode',
				'deleteNode',
				'copyNode',
				'addAsset',
				'deleteAsset',
				'deleteAllAssets',
				'combineAssets',
				'modifyAsset',
				'importView',
				'importAssets',
				'modifyActiveView',
				'behavior_save',
				'modifyProjectDetails',
				'modifyMocks',
			]
		})
	]
})

